/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.lottery.service.impl;

import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.activity.domain.lottery.LotteryMapper;
import com.bxm.fossicker.activity.domain.lottery.LotteryParticipantMapper;
import com.bxm.fossicker.activity.domain.lottery.LotteryPhaseMapper;
import com.bxm.fossicker.activity.facade.model.LotteryDTO;
import com.bxm.fossicker.activity.lottery.config.LotteryPhaseStatus;
import com.bxm.fossicker.activity.lottery.service.LotteryParticipantService;
import com.bxm.fossicker.activity.lottery.service.LotteryPhaseService;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryCarouselDTO;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryCompleteDTO;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryParticipantDTO;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryPhaseDetailDTO;
import com.bxm.fossicker.activity.model.param.lottery.LotteryPhaseQueryParam;
import com.bxm.fossicker.activity.model.param.lottery.LotteryQueryParam;
import com.bxm.fossicker.activity.model.vo.lottery.LotteryBean;
import com.bxm.fossicker.activity.model.vo.lottery.LotteryPhaseBean;
import com.bxm.fossicker.vo.PageWarper;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LotteryPhaseServiceImpl
extends BaseService
implements LotteryPhaseService {
    private final LotteryPhaseMapper lotteryPhaseMapper;
    private final LotteryMapper lotteryMapper;
    private final LotteryParticipantMapper lotteryParticipantMapper;
    private final RedisStringAdapter redisStringAdapter;
    private final RedisListAdapter redisListAdapter;
    private LotteryParticipantService lotteryParticipantService;

    @Autowired
    public LotteryPhaseServiceImpl(LotteryPhaseMapper lotteryPhaseMapper, LotteryMapper lotteryMapper, LotteryParticipantMapper lotteryParticipantMapper, RedisStringAdapter redisStringAdapter, RedisListAdapter redisListAdapter) {
        this.lotteryPhaseMapper = lotteryPhaseMapper;
        this.lotteryMapper = lotteryMapper;
        this.lotteryParticipantMapper = lotteryParticipantMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.redisListAdapter = redisListAdapter;
    }

    @Override
    public void createPhase(LotteryBean lottery) {
        LotteryPhaseBean newPhase = LotteryPhaseBean.builder().id(Long.valueOf(this.nextId())).status(Integer.valueOf(LotteryPhaseStatus.GOING.getCode())).conditionNum(lottery.getConditionNum()).participantNum(Integer.valueOf(0)).createTime(new Date()).phaseNum(String.valueOf(lottery.getPhaseCount() + 1)).lotteryId(lottery.getId()).build();
        this.lotteryPhaseMapper.insert(newPhase);
        this.changeLastPhase(lottery.getId(), newPhase.getId());
    }

    @Override
    public void resumePhase(LotteryBean lottery) {
        LotteryPhaseBean lastPhase = this.lotteryPhaseMapper.getLastPhase(lottery.getId(), null);
        if (null == lastPhase || lastPhase.getStatus().intValue() == LotteryPhaseStatus.FINISH.getCode()) {
            this.createPhase(lottery);
            return;
        }
        if (lastPhase.getStatus().intValue() == LotteryPhaseStatus.GOING.getCode()) {
            return;
        }
        lastPhase.setStatus(Integer.valueOf(LotteryPhaseStatus.GOING.getCode()));
        this.lotteryPhaseMapper.updateByPrimaryKeySelective(lastPhase);
    }

    @Override
    public void closePhase(LotteryPhaseBean entity) {
        this.lotteryPhaseMapper.updateByPrimaryKeySelective(entity);
        this.cleanCache(entity.getId());
        LotteryPhaseBean phaseInfo = this.lotteryPhaseMapper.selectByPrimaryKey(entity.getId());
        this.lotteryMapper.addNum(phaseInfo.getLotteryId());
        LotteryBean lotteryBean = this.lotteryMapper.selectByPrimaryKey(phaseInfo.getLotteryId());
        this.changeLastPhase(phaseInfo.getLotteryId(), null);
        this.createPhase(lotteryBean);
        this.redisListAdapter.leftPush(ActivityRedisKeyConstant.LOTTERY_CAROUSEL_KEY, new Object[]{LotteryCarouselDTO.builder().headImg(entity.getWinnerHeadUrl()).lotteryTitle(lotteryBean.getTitle()).nickName(entity.getWinnerName()).build()});
    }

    @Override
    public List<LotteryCarouselDTO> getCarousel() {
        List carouselList = this.redisListAdapter.range(ActivityRedisKeyConstant.LOTTERY_CAROUSEL_KEY, 0L, 5L, LotteryCarouselDTO.class);
        if (carouselList.size() < 5) {
            return Lists.newArrayList();
        }
        return carouselList;
    }

    @Override
    public Message modify(LotteryBean lottery) {
        Message message;
        LotteryPhaseBean lastPhase = this.lotteryPhaseMapper.getLastPhase(lottery.getId(), Integer.valueOf(LotteryPhaseStatus.GOING.getCode()));
        if (null != lastPhase && lottery.getConditionNum() > lastPhase.getConditionNum()) {
            this.logger.debug("\u6d3b\u52a8\u4fe1\u606f\u53d8\u66f4\uff0c\u539f\u59cb\u5f00\u5956\u4eba\u6570\uff1a{},\u73b0\u5f00\u5956\u4eba\u6570\uff1a{}", (Object)lastPhase.getConditionNum(), (Object)lottery.getConditionNum());
            lastPhase.setConditionNum(lottery.getConditionNum());
            message = Message.build((int)this.lotteryPhaseMapper.updateByPrimaryKeySelective(lastPhase));
        } else {
            message = Message.build();
            this.logger.info("\u6d3b\u52a8\u5f00\u5956\u4eba\u6570\u672a\u53d8\u5316\uff0c\u4e0d\u505a\u5904\u7406,\u53c2\u6570\uff1a{}", (Object)lottery);
        }
        return message;
    }

    @Override
    public Message cancel(LotteryBean lottery) {
        LotteryPhaseBean lastPhase = this.lotteryPhaseMapper.getLastPhase(lottery.getId(), Integer.valueOf(LotteryPhaseStatus.GOING.getCode()));
        if (null != lastPhase) {
            int realUserCount = this.lotteryParticipantMapper.getRealUserCount(lastPhase.getId());
            if (realUserCount == 0) {
                LotteryPhaseBean modifyEntity = LotteryPhaseBean.builder().id(lastPhase.getId()).status(Integer.valueOf(LotteryPhaseStatus.CANCEL.getCode())).build();
                this.lotteryPhaseMapper.updateByPrimaryKeySelective(modifyEntity);
            } else {
                this.logger.info("\u6d3b\u52a8\u5b58\u5728\u771f\u5b9e\u53c2\u4e0e\u7528\u6237\uff0c\u4e0d\u8fdb\u884c\u53d6\u6d88,phaseId\uff1a{}", (Object)lastPhase.getId());
            }
        }
        return Message.build();
    }

    @Override
    public void changeLastPhase(Long lotteryId, Long phaseId) {
        Preconditions.checkArgument((null != lotteryId ? 1 : 0) != 0);
        this.lotteryPhaseMapper.setLastPhaseId(lotteryId, phaseId);
        List otherPhaseIds = this.lotteryPhaseMapper.getAllPhaseByLottery(lotteryId, phaseId);
        if (!CollectionUtils.isEmpty((Collection)otherPhaseIds)) {
            ArrayList removeKeys = Lists.newArrayList();
            for (Long otherPhaseId : otherPhaseIds) {
                removeKeys.add(this.buildKey(otherPhaseId));
            }
            this.redisStringAdapter.remove((List)removeKeys);
        }
    }

    @Override
    public LotteryPhaseDetailDTO loadCache(Long phaseId) {
        KeyGenerator key = this.buildKey(phaseId);
        LotteryPhaseDetailDTO res = (LotteryPhaseDetailDTO)this.redisStringAdapter.get(key, LotteryPhaseDetailDTO.class);
        if (null == res) {
            res = this.lotteryPhaseMapper.getDetail(phaseId);
            if (res == null) {
                res = LotteryPhaseDetailDTO.builder().build();
                res.setPhaseId(phaseId);
                this.redisStringAdapter.set(key, (Object)res, 60L);
            } else {
                this.redisStringAdapter.set(key, (Object)res);
            }
        }
        return res;
    }

    @Override
    public void cleanCache(Long phaseId) {
        KeyGenerator key = this.buildKey(phaseId);
        this.redisStringAdapter.remove(key);
    }

    private LotteryParticipantService getLotteryParticipantService() {
        if (this.lotteryParticipantService == null) {
            this.lotteryParticipantService = (LotteryParticipantService)SpringContextHolder.getBean(LotteryParticipantService.class);
        }
        return this.lotteryParticipantService;
    }

    @Override
    public PageWarper<LotteryDTO> getPhaseList(LotteryQueryParam param) {
        List result = this.lotteryPhaseMapper.getPhaseByPage(param);
        Map<String, Integer> userJoinHistories = this.getLotteryParticipantService().loadJoinHistoryMap(param.getUserId(), null);
        for (LotteryDTO item : result) {
            Integer joinTimes = userJoinHistories.get(String.valueOf(item.getPhaseId()));
            if (null == joinTimes || joinTimes <= 0) continue;
            item.setTimes(joinTimes);
        }
        return new PageWarper(result);
    }

    @Override
    public PageWarper<LotteryCompleteDTO> getCompletePhaseList(LotteryPhaseQueryParam param) {
        List result = this.lotteryPhaseMapper.getPhaseCompleteByPage(param);
        Map<String, Integer> userJoinHistories = this.getLotteryParticipantService().loadJoinHistoryMap(param.getUserId(), null);
        for (LotteryDTO item : result) {
            Integer joinTimes = userJoinHistories.get(String.valueOf(item.getPhaseId()));
            if (null == joinTimes || joinTimes <= 0) continue;
            item.setTimes(joinTimes);
        }
        return new PageWarper(result);
    }

    @Override
    public LotteryPhaseDetailDTO getDetail(LotteryPhaseQueryParam param) {
        LotteryPhaseDetailDTO detailDTO = this.loadCache(param.getPhaseId());
        detailDTO.setMyCodes(this.lotteryParticipantMapper.getJoinHistoryCodes(param.getPhaseId(), param.getUserId()));
        if (null != detailDTO.getMyCodes() && detailDTO.getMyCodes().size() > 0) {
            detailDTO.setTimes(Integer.valueOf(detailDTO.getMyCodes().size()));
        }
        LotteryPhaseQueryParam pageParam = new LotteryPhaseQueryParam();
        pageParam.setPhaseId(param.getPhaseId());
        pageParam.setUserId(param.getUserId());
        PageWarper<LotteryParticipantDTO> participantList = this.getLotteryParticipantService().getParticipantList(pageParam);
        detailDTO.setFirstPageParticipant(participantList);
        return detailDTO;
    }

    private KeyGenerator buildKey(Long phaseId) {
        return ActivityRedisKeyConstant.LOTTERY_PHASE_KEY.copy().appendKey((Object)phaseId);
    }
}

