/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.advert.filter.general;

import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.service.advert.annotation.AdverFilter;
import com.bxm.fossicker.activity.service.advert.bo.AdvertisementFilterParam;
import com.bxm.fossicker.activity.service.advert.impl.AbstractAdvertisementFilter;
import com.bxm.fossicker.activity.service.config.ActivityProperties;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.StringUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.springframework.beans.factory.annotation.Autowired;

@AdverFilter
public class Taoqi365AdvertisementFilter
extends AbstractAdvertisementFilter {
    private final ActivityProperties activityProperties;
    private static final String URL_PREFIX = "http://tq.jfshou.cn";

    @Autowired
    public Taoqi365AdvertisementFilter(ActivityProperties activityProperties) {
        this.activityProperties = activityProperties;
    }

    @Override
    protected boolean doFilter(List<AdvertDto> advertDtos, AdvertisementFilterParam param) {
        advertDtos.forEach(item -> {
            if (StringUtils.startsWith((CharSequence)item.getUrl(), (CharSequence)URL_PREFIX)) {
                item.setUrl(this.parseUrl(item.getUrl(), param));
            }
        });
        return true;
    }

    private String parseUrl(String sourceUrl, AdvertisementFilterParam param) {
        if (StringUtils.isBlank((CharSequence)sourceUrl)) {
            return sourceUrl;
        }
        sourceUrl = sourceUrl.contains("?") ? sourceUrl + "&" : sourceUrl + "?";
        sourceUrl = sourceUrl + "machineCode=" + param.getAdvertParam().getUserId();
        sourceUrl = sourceUrl + "&agentId=" + this.activityProperties.getTaoqi365AgentId();
        sourceUrl = sourceUrl + "&timestamp=" + System.currentTimeMillis();
        List paramList = URLEncodedUtils.parse((String)StringUtils.substring((String)sourceUrl, (int)(sourceUrl.indexOf("?") + 1)), (Charset)StandardCharsets.UTF_8);
        paramList = paramList.stream().sorted(Comparator.comparing(NameValuePair::getName)).collect(Collectors.toList());
        StringBuilder signSource = new StringBuilder();
        for (NameValuePair nameValuePair : paramList) {
            signSource.append(nameValuePair.getName()).append("=").append(nameValuePair.getValue());
            signSource.append("&");
        }
        signSource.append("secretKey").append("=").append(this.activityProperties.getTaoqi365SecertKey());
        sourceUrl = sourceUrl + "&sign=" + MD5Util.hgmd5((String)signSource.toString()).toUpperCase();
        return sourceUrl;
    }
}

