/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.advert.filter.position;

import com.bxm.fossicker.activity.config.AdvertConfig;
import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.model.enums.AdvertPositionEnum;
import com.bxm.fossicker.activity.service.advert.annotation.AdverFilter;
import com.bxm.fossicker.activity.service.advert.bo.AdvertisementFilterParam;
import com.bxm.fossicker.activity.service.advert.impl.AbstractAdvertisementFilter;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.fossicker.user.facade.enums.VipTypeEnum;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;

@AdverFilter(value={AdvertPositionEnum.USER_PAGE_TOP_BUTTON})
public class MinePageTopIconFilter
extends AbstractAdvertisementFilter {
    @Resource
    private AdvertConfig advertConfig;

    @Override
    protected boolean doFilter(List<AdvertDto> advertDtos, AdvertisementFilterParam param) {
        UserInfoDto user = param.getUserInfoDto();
        if (this.removeInputInviteCode(user, param).booleanValue()) {
            advertDtos.removeIf(p -> Objects.equals(p.getTitle(), this.advertConfig.getMinePageTopInputInviteCodeIconName()));
        } else {
            int registerDays = this.getRegisterDays(param);
            if (registerDays > this.advertConfig.getInputInviteCodeShowDays()) {
                advertDtos.removeIf(p -> Objects.equals(p.getTitle(), this.advertConfig.getMinePageTopInputInviteCodeIconName()));
            } else {
                advertDtos.removeIf(p -> Objects.equals(p.getTitle(), this.advertConfig.getMinePageTopInviteUserIconName()));
            }
        }
        if (user.getVip() == VipTypeEnum.VIP_FOREVER.getType()) {
            advertDtos.removeIf(p -> Objects.equals(p.getTitle(), this.advertConfig.getMinePageTopFreeGetVip()));
        }
        return true;
    }

    private Boolean removeInputInviteCode(UserInfoDto user, AdvertisementFilterParam param) {
        return Objects.nonNull(user.getSuperiorUserId()) && !Objects.equals(user.getSuperiorUserId(), 0L) || param.getUserInfoFacadeService().checkIsSpecialRegChannel(user.getRegChannel()) != false;
    }

    private int getRegisterDays(AdvertisementFilterParam param) {
        UserInfoDto userInfo = param.getUserInfoDto();
        if (null == userInfo) {
            return -1;
        }
        if (userInfo.getCreateTime() == null) {
            return -1;
        }
        return DateUtils.getDiffDays((Date)userInfo.getCreateTime(), (Date)new Date(), (boolean)true);
    }
}

