/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.gold.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.activity.enums.DoubleGoldTypeEnum;
import com.bxm.fossicker.activity.model.param.GoldDoubleParam;
import com.bxm.fossicker.activity.service.gold.DoubleGoldService;
import com.bxm.fossicker.activity.service.gold.strategy.DoubleGoldStrategyService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DoubleGoldServiceImpl
implements DoubleGoldService {
    private static final Logger log = LoggerFactory.getLogger(DoubleGoldServiceImpl.class);
    @Resource(name="doubleGoldByBoxService")
    private DoubleGoldStrategyService doubleGoldByBoxService;
    @Resource(name="doubleGoldByBrowseService")
    private DoubleGoldStrategyService doubleGoldByBrowseService;
    @Resource(name="doubleGoldBySignService")
    private DoubleGoldStrategyService doubleGoldBySignService;
    @Resource(name="doubleGoldByTaskService")
    private DoubleGoldStrategyService doubleGoldByTaskService;
    @Resource(name="doubleGoldByNewbieGoldService")
    private DoubleGoldStrategyService doubleGoldByNewbieGoldService;

    @Override
    public Integer doubleGoldByType(GoldDoubleParam goldDoubleParam) {
        DoubleGoldStrategyService doubleGoldStrategyService = this.serviceFactory(goldDoubleParam.getType());
        if (null == doubleGoldStrategyService) {
            log.error("\u6839\u636e\u7c7b\u578b\u521b\u5efa\u5bf9\u8c61\u5931\u8d25,\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)goldDoubleParam));
            return null;
        }
        return doubleGoldStrategyService.doubleGold(goldDoubleParam);
    }

    private DoubleGoldStrategyService serviceFactory(Integer type) {
        DoubleGoldStrategyService doubleGoldStrategyService;
        DoubleGoldTypeEnum doubleGoldTypeEnum = DoubleGoldTypeEnum.getEnumByType((Integer)type);
        switch (doubleGoldTypeEnum) {
            case BOX: {
                doubleGoldStrategyService = this.doubleGoldByBoxService;
                break;
            }
            case BROWSE: {
                doubleGoldStrategyService = this.doubleGoldByBrowseService;
                break;
            }
            case SIGN: {
                doubleGoldStrategyService = this.doubleGoldBySignService;
                break;
            }
            case TASK: {
                doubleGoldStrategyService = this.doubleGoldByTaskService;
                break;
            }
            case NEWBIE_GOLD: {
                doubleGoldStrategyService = this.doubleGoldByNewbieGoldService;
                break;
            }
            case UNDEFINED: {
                return null;
            }
            default: {
                return null;
            }
        }
        return doubleGoldStrategyService;
    }
}

