/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.gold.strategy.impl;

import com.bxm.fossicker.activity.model.constant.ActivityRedisKey;
import com.bxm.fossicker.activity.model.param.GoldDoubleParam;
import com.bxm.fossicker.activity.service.gold.strategy.AbstractDoubleGoldStrategyService;
import com.bxm.fossicker.activity.service.sign.SignService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="doubleGoldBySignService")
public class DoubleGoldBySignServiceImpl
extends AbstractDoubleGoldStrategyService {
    private static final Logger log = LoggerFactory.getLogger(DoubleGoldBySignServiceImpl.class);
    @Autowired
    private SignService signService;
    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Override
    public Integer doubleGold(GoldDoubleParam goldDoubleParam) {
        KeyGenerator limitKey = ActivityRedisKey.DOUBLE_GOLD_LIMIT.copy().appendKey((Object)goldDoubleParam.getType()).appendKey((Object)goldDoubleParam.getUserId()).appendKey((Object)DateUtils.getCurrentDate());
        if (StringUtils.isNotBlank((CharSequence)this.redisStringAdapter.getString(limitKey))) {
            log.error("\u7b7e\u5230\u7ffb\u500d\u91d1\u5e01\u4eca\u65e5\u5df2\u9886\u53d6,\u4e0d\u518d\u88ab\u9886\u53d6");
            return null;
        }
        Integer signReward = this.signService.getSignReward(goldDoubleParam.getUserId());
        this.addGold(new BigDecimal(signReward), goldDoubleParam);
        this.redisStringAdapter.set(limitKey, (Object)signReward, 86400L);
        return this.showGoldNum(signReward, goldDoubleParam.getCurVer());
    }
}

