/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.domain.SwlhCalbackLogMapper;
import com.bxm.fossicker.activity.model.dto.ExternalGoldInfoDto;
import com.bxm.fossicker.activity.model.param.ExternalGoldOperateParam;
import com.bxm.fossicker.activity.model.param.TaskCallBackParam;
import com.bxm.fossicker.activity.model.vo.SwlhCalbackLog;
import com.bxm.fossicker.activity.service.ExternalAdvertService;
import com.bxm.fossicker.enums.UserGoldFlowTypeEnum;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.fossicker.user.facade.enums.CashTypeDetail;
import com.bxm.fossicker.user.facade.param.CashIncrementParam;
import com.bxm.fossicker.user.facade.param.GoldRebateParam;
import com.bxm.fossicker.user.model.dto.AccountDetailDto;
import com.bxm.newidea.component.vo.Message;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExternalAdvertServiceImpl
implements ExternalAdvertService {
    @Resource
    private SwlhCalbackLogMapper swlhCalbackLogMapper;
    @Autowired
    private AccountFacadeService accountFacadeService;
    @Autowired
    private UserInfoFacadeService userInfoFacadeService;

    @Override
    public boolean doCallBackLogic(TaskCallBackParam param) {
        SwlhCalbackLog swlhCalbackLog = new SwlhCalbackLog();
        BeanUtils.copyProperties((Object)param, (Object)swlhCalbackLog);
        int result = this.swlhCalbackLogMapper.save(swlhCalbackLog);
        if (result != 1) {
            return false;
        }
        CashIncrementParam cashIncrementParam = new CashIncrementParam(param.getUid(), param.getMoney(), swlhCalbackLog.getId(), CashTypeDetail.PLAY_GAME);
        this.accountFacadeService.cashIncrement(cashIncrementParam);
        return Boolean.TRUE;
    }

    @Override
    public ExternalGoldInfoDto getUserInfo(Long userId) {
        AccountDetailDto dto = this.accountFacadeService.loadAccountDetail(userId);
        ExternalGoldInfoDto result = new ExternalGoldInfoDto();
        UserInfoDto userInfoDto = this.userInfoFacadeService.getUserById(userId);
        if (userInfoDto != null && dto != null) {
            result.setUserId(userId);
            result.setNickname(userInfoDto.getNickName());
            result.setGoldNum(dto.getUsableGold());
            result.setHeadImg(userInfoDto.getHeadImg());
        }
        return result;
    }

    @Override
    public Message subtractGold(ExternalGoldOperateParam param) {
        GoldRebateParam goldRebateParam = new GoldRebateParam();
        goldRebateParam.setUserId(param.getUserId());
        goldRebateParam.setAmount(param.getSubtractGoldNum());
        goldRebateParam.setUserGoldFlowType(UserGoldFlowTypeEnum.ADVERT_TJG_SUBTRACT_GOLD);
        return this.accountFacadeService.subtractGoldRebate(goldRebateParam);
    }
}

