/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.config.TaskConfig;
import com.bxm.fossicker.activity.service.AccountIntegrationService;
import com.bxm.fossicker.activity.service.ActivityAction;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.newidea.component.redis.DistributedLock;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="new_user_red_packet")
public class NewUserRedPacketActionImpl
implements ActivityAction {
    private static final Logger log = LogManager.getLogger(NewUserRedPacketActionImpl.class);
    private final AccountIntegrationService accountIntegrationService;
    private final UserInfoFacadeService userInfoFacadeService;
    private final TaskConfig taskConfig;
    private DistributedLock distributedLock;

    @Autowired
    public NewUserRedPacketActionImpl(AccountIntegrationService accountIntegrationService, TaskConfig taskConfig, UserInfoFacadeService userInfoFacadeService, DistributedLock distributedLock) {
        this.accountIntegrationService = accountIntegrationService;
        this.taskConfig = taskConfig;
        this.userInfoFacadeService = userInfoFacadeService;
        this.distributedLock = distributedLock;
    }

    @Override
    public BigDecimal reward(Long userId) {
        String requestId;
        String resource;
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237[{}]\u9886\u53d6\u65b0\u4eba\u793c\u5305", (Object)userId);
        }
        if (!this.distributedLock.lock(resource = StringUtils.join((Object[])new String[]{"NEW_USER_RED_PACKET", requestId = Objects.toString(userId)}), requestId, 2L, TimeUnit.SECONDS)) {
            log.warn("\u9886\u53d6\u65b0\u4eba\u793c\u5305\u8bf7\u6c42\u9891\u7e41");
            return new BigDecimal(0);
        }
        UserInfoDto userInfoDto = this.userInfoFacadeService.getUserById(userId);
        if (Objects.isNull(userInfoDto) || Objects.isNull(userInfoDto.getClaimedPacket()) || Objects.equals(userInfoDto.getClaimedPacket(), Boolean.TRUE)) {
            return new BigDecimal(0);
        }
        this.accountIntegrationService.rewardNewUserRedPacket(userId);
        this.userInfoFacadeService.claimedPacket(userId);
        this.distributedLock.unlock(resource, requestId);
        return this.taskConfig.getNewUserRedPacket();
    }
}

