/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.model.constant.ActivityRedisKey;
import com.bxm.fossicker.activity.model.vo.OpenTreasureBoxDTO;
import com.bxm.fossicker.activity.model.vo.TreasureBoxVO;
import com.bxm.fossicker.activity.service.TreasureBoxActivityService;
import com.bxm.fossicker.activity.service.config.ActivityProperties;
import com.bxm.fossicker.enums.UserGoldFlowTypeEnum;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.param.GoldRebateParam;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TreasureBoxActivityServiceImpl
implements TreasureBoxActivityService {
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private AccountFacadeService accountFacadeService;
    @Autowired
    private ActivityProperties activityProperties;

    @Override
    public TreasureBoxVO treasureBox(Long userId) {
        Date nextOpenTime = (Date)this.redisHashMapAdapter.get(ActivityRedisKey.TREASURE_BOX_CACHE.copy(), userId.toString(), Date.class);
        if (Objects.isNull(nextOpenTime)) {
            return TreasureBoxVO.builder().nextOpenTime(new Date()).status(Integer.valueOf(1)).build();
        }
        return TreasureBoxVO.builder().nextOpenTime(nextOpenTime).status(Integer.valueOf(nextOpenTime.before(new Date()) ? 1 : 0)).build();
    }

    @Override
    public OpenTreasureBoxDTO openTreasureBox(Long userId) {
        OpenTreasureBoxDTO openTreasureBoxResultDTO = new OpenTreasureBoxDTO();
        Date openTime = (Date)this.redisHashMapAdapter.get(ActivityRedisKey.TREASURE_BOX_CACHE.copy(), userId.toString(), Date.class);
        Date now = new Date();
        if (!Objects.isNull(openTime) && openTime.after(now)) {
            openTreasureBoxResultDTO.setOpenStatus(Integer.valueOf(0));
            return openTreasureBoxResultDTO;
        }
        Date nextOpenTime = DateUtils.addField((Date)now, (int)10, (int)4);
        this.redisHashMapAdapter.put(ActivityRedisKey.TREASURE_BOX_CACHE.copy(), userId.toString(), (Object)nextOpenTime);
        String awardGoldNum = this.activityProperties.getBoxAwardGold();
        this.accountFacadeService.goldRebate(GoldRebateParam.builder().amount(new BigDecimal(awardGoldNum)).relationId(null).userGoldFlowType(UserGoldFlowTypeEnum.TREASURE_BOX).userId(userId).build());
        openTreasureBoxResultDTO.setOpenStatus(Integer.valueOf(1));
        openTreasureBoxResultDTO.setBoxStatus(Integer.valueOf(0));
        openTreasureBoxResultDTO.setNextOpenTime(nextOpenTime);
        openTreasureBoxResultDTO.setRewardNum(awardGoldNum);
        return openTreasureBoxResultDTO;
    }
}

