/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.config.InviteConfig;
import com.bxm.fossicker.activity.domain.UserAddressListMapper;
import com.bxm.fossicker.activity.model.dto.PhoneStatusDto;
import com.bxm.fossicker.activity.model.param.AddPhoneListParam;
import com.bxm.fossicker.activity.model.param.AddPhoneParam;
import com.bxm.fossicker.activity.model.vo.UserAddressList;
import com.bxm.fossicker.activity.service.UserAddressListService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class UserAddressListServiceImpl
implements UserAddressListService {
    private static final Logger log = LogManager.getLogger(UserAddressListServiceImpl.class);
    private final UserAddressListMapper addressListMapper;
    private final SequenceCreater sequenceCreater;
    private final InviteConfig inviteConfig;

    @Autowired
    public UserAddressListServiceImpl(UserAddressListMapper addressListMapper, SequenceCreater sequenceCreater, InviteConfig inviteConfig) {
        this.addressListMapper = addressListMapper;
        this.sequenceCreater = sequenceCreater;
        this.inviteConfig = inviteConfig;
    }

    @Override
    @Transactional
    public List<PhoneStatusDto> uploadPhone(AddPhoneListParam addPhoneListParam) {
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237\u5f00\u59cb\u4e0a\u4f20\u901a\u8baf\u5f55\u53f7\u7801,[{}]", (Object)addPhoneListParam.toString());
        }
        List existUserAddressLists = this.addressListMapper.listByUserId(addPhoneListParam.getUserId());
        if (!CollectionUtils.isEmpty((Collection)addPhoneListParam.getAddPhoneList())) {
            this.cleanPhones(addPhoneListParam);
            Set phoneSet = existUserAddressLists.stream().map(UserAddressList::getPhone).collect(Collectors.toSet());
            List newUserAddressLists = addPhoneListParam.getAddPhoneList().stream().filter(addPhoneParam -> StringUtils.isNotBlank((CharSequence)addPhoneParam.getPhone()) && addPhoneParam.getPhone().trim().length() == 11 && addPhoneParam.getPhone().trim().startsWith("1") && !phoneSet.contains(addPhoneParam.getPhone())).map(addPhoneParam -> this.build(addPhoneListParam.getUserId(), (AddPhoneParam)addPhoneParam)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(newUserAddressLists)) {
                this.addressListMapper.batchAdd(newUserAddressLists);
                existUserAddressLists.addAll(newUserAddressLists);
            }
        }
        return existUserAddressLists.stream().map(this::convert).collect(Collectors.toList());
    }

    private void cleanPhones(AddPhoneListParam addPhoneListParam) {
        addPhoneListParam.getAddPhoneList().forEach(addPhoneParam -> {
            String phone = addPhoneParam.getPhone();
            if (StringUtils.isNotBlank((CharSequence)phone)) {
                if (phone.contains("-")) {
                    phone = phone.replace("-", "");
                }
                if (phone.contains("+86")) {
                    phone = phone.replace("+86", "");
                }
                if (phone.contains(" ")) {
                    phone = phone.replace(" ", "");
                }
                addPhoneParam.setPhone(phone);
            }
        });
    }

    private UserAddressList build(Long userId, AddPhoneParam addPhoneParam) {
        return UserAddressList.builder().id(this.sequenceCreater.nextLongId()).inviteStatus(Integer.valueOf(0)).linkman(addPhoneParam.getName()).phone(addPhoneParam.getPhone()).userId(userId).build();
    }

    @Override
    @Transactional
    public Boolean invited(Long userId, String phone) {
        Long id = this.exists(userId, phone);
        return null == id ? this.add(userId, phone) : this.invited(id);
    }

    @Override
    public Long exists(Long userId, String phone) {
        UserAddressList addressList = this.addressListMapper.query(userId, phone);
        return null == addressList ? null : addressList.getId();
    }

    @Override
    public Boolean invited(Long id) {
        return this.addressListMapper.updateStatus(id, Integer.valueOf(1)) > 0;
    }

    @Override
    public Boolean add(Long userId, String phone) {
        return this.addressListMapper.addOne(UserAddressList.builder().id(this.sequenceCreater.nextLongId()).userId(userId).phone(phone).linkman("").inviteStatus(Integer.valueOf(1)).build());
    }

    private PhoneStatusDto convert(UserAddressList userAddressList) {
        return PhoneStatusDto.builder().id(userAddressList.getId()).name(userAddressList.getLinkman()).phone(new StringBuffer(userAddressList.getPhone()).replace(3, 7, "****").toString()).invited(Boolean.valueOf(userAddressList.getInviteStatus() == 1)).probablyAmount(this.inviteConfig.getReward().toString()).build();
    }
}

