/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.sign.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.activity.facade.ActivitySignFacadeService;
import com.bxm.fossicker.activity.model.SignWithdrawDaysModel;
import com.bxm.fossicker.activity.service.WithdrawService;
import com.bxm.fossicker.activity.service.config.SignConfig;
import com.bxm.fossicker.activity.service.sign.ActivitySignService;
import com.bxm.fossicker.activity.service.sign.SignService;
import com.bxm.fossicker.enums.WithdrawTypeEnum;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ActivitySignServiceImpl
implements ActivitySignService,
ActivitySignFacadeService {
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private SignConfig signConfig;
    private SignService signService;
    private WithdrawService withdrawService;

    private WithdrawService getWithdrawService() {
        if (null == this.withdrawService) {
            this.withdrawService = (WithdrawService)SpringContextHolder.getBean(WithdrawService.class);
        }
        return this.withdrawService;
    }

    private SignService getSignService() {
        if (null == this.signService) {
            this.signService = (SignService)SpringContextHolder.getBean(SignService.class);
        }
        return this.signService;
    }

    @Override
    public Boolean doSign(Long userId) {
        KeyGenerator activitySignKey = ActivityRedisKeyConstant.ACTIVITY_SIGN_DAY;
        this.redisHashMapAdapter.increment(activitySignKey, userId.toString(), 1);
        Long signedDays = this.redisHashMapAdapter.getLong(activitySignKey, userId.toString());
        this.addWithdraw(userId, signedDays.intValue());
        return true;
    }

    @Override
    public Integer getSignedDay(Long userId) {
        KeyGenerator activitySignKey = ActivityRedisKeyConstant.ACTIVITY_SIGN_DAY;
        Long signedDays = this.redisHashMapAdapter.getLong(activitySignKey, userId.toString());
        return signedDays.intValue();
    }

    @Override
    public boolean usedChance(Long userId) {
        KeyGenerator activitySignKey = ActivityRedisKeyConstant.ACTIVITY_SIGN_DAY;
        this.redisHashMapAdapter.remove(activitySignKey, new String[]{userId.toString()});
        return true;
    }

    public void checkInfo() {
        KeyGenerator activitySignKey = ActivityRedisKeyConstant.ACTIVITY_SIGN_DAY;
        Map userIdMap = this.redisHashMapAdapter.entries(activitySignKey, Long.class);
        Set userIdSet = userIdMap.keySet();
        userIdSet.forEach(userId -> {
            Long userIdLong = Long.valueOf(userId);
            if (this.getSignService().isStopSigned(userIdLong)) {
                this.getWithdrawService().used(userIdLong);
            }
        });
    }

    private void addWithdraw(Long userId, Integer signedDays) {
        List withdrawDaysModels = JSONObject.parseArray((String)this.signConfig.getWithdrawDays(), SignWithdrawDaysModel.class);
        Map<Integer, String> withdrawDaysModelsMap = withdrawDaysModels.stream().collect(Collectors.toMap(SignWithdrawDaysModel::getDays, SignWithdrawDaysModel::getType));
        if (withdrawDaysModelsMap.containsKey(signedDays)) {
            this.getWithdrawService().add(userId, WithdrawTypeEnum.valueOf((String)withdrawDaysModelsMap.get(signedDays)));
        }
        if (Objects.nonNull(signedDays) && signedDays % this.signConfig.getNewSingDays() == 0) {
            this.getWithdrawService().add(userId, 4);
        }
    }
}

