/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.sign.impl;

import com.bxm.fossicker.activity.domain.ActivitySignLogMapper;
import com.bxm.fossicker.activity.facade.SignFacadeService;
import com.bxm.fossicker.activity.facade.model.SignFacadeDto;
import com.bxm.fossicker.activity.model.DayRewardModel;
import com.bxm.fossicker.activity.model.dto.SignAndInfoDTO;
import com.bxm.fossicker.activity.model.dto.SignDaysDto;
import com.bxm.fossicker.activity.model.dto.SignDto;
import com.bxm.fossicker.activity.model.dto.SignTodayDTO;
import com.bxm.fossicker.activity.model.vo.ActivitySignLog;
import com.bxm.fossicker.activity.service.AccountIntegrationService;
import com.bxm.fossicker.activity.service.config.SignConfig;
import com.bxm.fossicker.activity.service.sign.ActivitySignService;
import com.bxm.fossicker.activity.service.sign.SignService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SignServiceImpl
implements SignService,
SignFacadeService {
    private static final Logger log = LogManager.getLogger(SignServiceImpl.class);
    private final ActivitySignLogMapper signLogMapper;
    private final SequenceCreater sequenceCreater;
    private final SignConfig signConfig;
    private final AccountIntegrationService accountIntegrationService;
    private ActivitySignLogMapper activitySignLogMapper;
    private ActivitySignService activitySignService;

    @Autowired
    public SignServiceImpl(ActivitySignLogMapper signLogMapper, SequenceCreater sequenceCreater, SignConfig signConfig, AccountIntegrationService accountIntegrationService, ActivitySignLogMapper activitySignLogMapper, ActivitySignService activitySignService) {
        this.signLogMapper = signLogMapper;
        this.sequenceCreater = sequenceCreater;
        this.signConfig = signConfig;
        this.accountIntegrationService = accountIntegrationService;
        this.activitySignLogMapper = activitySignLogMapper;
        this.activitySignService = activitySignService;
    }

    @Override
    @Transactional
    public SignDto signInfo(Long userId) {
        if (null == userId) {
            return null;
        }
        Integer signedDays = this.getSignedDays(userId);
        return this.convertToSignDto(this.signConfig.getDayReward(), signedDays);
    }

    @Override
    public SignDto signInfoSeven(Long userId) {
        if (null == userId) {
            return null;
        }
        Integer signedDays = this.getSignedDays(userId);
        return this.convertToSignDtoSevenDay(this.signConfig.getDayReward(), signedDays, userId);
    }

    @Override
    public Integer getSignReward(Long userId) {
        if (null == userId) {
            return null;
        }
        Integer signedDays = this.getSignedDays(userId);
        DayRewardModel dayRewardModel = this.signConfig.getDayReward().get(signedDays);
        return dayRewardModel.getReward() + dayRewardModel.getExtraReward();
    }

    public Boolean didSign(Long userId, Date date) {
        ActivitySignLog activitySignLog = this.activitySignLogMapper.queryByUserIdAndSignDate(userId, date);
        return !Objects.isNull(activitySignLog);
    }

    public SignFacadeDto getSignInfo(Long userId) {
        if (null == userId) {
            return null;
        }
        SignFacadeDto signResultDTO = new SignFacadeDto();
        Integer signedDays = this.getSignedDays(userId);
        DayRewardModel dayRewardModel = this.signConfig.getDayReward().get(signedDays);
        Integer rewardGold = dayRewardModel.getReward() + dayRewardModel.getExtraReward();
        signResultDTO.setSignDays(signedDays);
        signResultDTO.setRewardGold(rewardGold);
        return signResultDTO;
    }

    @Override
    public SignTodayDTO getTodaySignInfo(Long userId) {
        if (null == userId) {
            return null;
        }
        return SignTodayDTO.builder().signDays(this.activitySignService.getSignedDay(userId)).todaySignFlag(Boolean.valueOf(this.isSignToday(userId))).build();
    }

    @Override
    public boolean isSignToday(Long userId) {
        boolean signedToday;
        Date date = this.signLogMapper.querySignLastDate(userId);
        boolean bl = signedToday = DateUtils.getDiffSeconed((Date)DateUtils.getClearDate((Date)date), (Date)DateUtils.getClearDate((Date)new Date()), (boolean)Boolean.FALSE) == 0L;
        return null != date && signedToday;
    }

    public boolean signByDay(Long userId) {
        boolean signedToday;
        if (null == userId) {
            return false;
        }
        Integer signedDays = this.getSignedDays(userId);
        Date date = this.signLogMapper.querySignLastDate(userId);
        boolean bl = signedToday = DateUtils.getDiffSeconed((Date)DateUtils.getClearDate((Date)date), (Date)DateUtils.getClearDate((Date)new Date()), (boolean)Boolean.FALSE) == 0L;
        if (null == date || !signedToday) {
            if (log.isDebugEnabled()) {
                log.debug("\u7528\u6237[{}]\u5df2\u8fde\u7eed\u7b7e\u5230[{}]\u5929\uff0c\u4eca\u65e5\u672a\u7b7e\u5230\uff0c\u6267\u884c\u7b7e\u5230\u64cd\u4f5c", (Object)userId, (Object)signedDays);
            }
            Integer signDay = this.nextSignDayBySignedDays(signedDays);
            DayRewardModel dayRewardModel = this.signConfig.getDayReward().get(signDay);
            ActivitySignLog signLog = this.convertToActivitySignLog(userId, dayRewardModel);
            this.signLogMapper.addOne(signLog);
            this.accountIntegrationService.rewardSign(userId, signLog.getReward());
            this.activitySignService.doSign(userId);
            return true;
        }
        return false;
    }

    public Integer getTodaySignReward(Long userId) {
        Integer signedDays = this.getSignedDays(userId);
        Integer signDay = this.nextSignDayBySignedDays(signedDays);
        DayRewardModel dayRewardModel = this.signConfig.getDayReward().get(signDay);
        return dayRewardModel.getReward() + dayRewardModel.getExtraReward();
    }

    @Override
    public boolean isStopSigned(Long userId) {
        Date lastSignDate = this.signLogMapper.querySignLastDate(userId);
        if (Objects.isNull(lastSignDate)) {
            return true;
        }
        Date lastDayClearDate = DateUtils.getClearDate((Date)DateUtils.addField((Date)new Date(), (int)5, (int)-1));
        return DateUtils.before((Date)lastSignDate, (Date)lastDayClearDate);
    }

    private SignDto convertToSignDtoSevenDay(List<DayRewardModel> dayRewardModels, Integer signedDays, Long userId) {
        int begin;
        SignDto signDto = new SignDto();
        signDto.setPeriodDays(this.signConfig.getCircle());
        signDto.setPeriodRewardGold(this.signConfig.getCircleReward());
        signDto.setSignDays(signedDays);
        signDto.setSignToday(this.isSignToday(userId));
        ArrayList signDaysDtoList = Lists.newArrayList();
        for (int i = begin = signedDays < 7 ? 1 : (signedDays < 9 ? 8 : 9); i < begin + 7; ++i) {
            signDaysDtoList.add(this.convertToSignDaysDto(signedDays, dayRewardModels.get(i)));
        }
        signDto.setSignDaysDtoList((List)signDaysDtoList);
        Integer tomorrowGold = dayRewardModels.get(signedDays % 15 + 1).getReward();
        if (dayRewardModels.get(signedDays % 15 + 1).getHasExtra().booleanValue()) {
            tomorrowGold = tomorrowGold + dayRewardModels.get(signedDays % 15 + 1).getExtraReward();
        }
        signDto.setTomorrowGold(tomorrowGold);
        if (!signDto.isSignToday()) {
            Optional<SignDaysDto> signDtoOptional = signDaysDtoList.stream().filter(e -> e.getStatus().equals(0)).findFirst();
            signDtoOptional.ifPresent(e -> e.setTodayShowSign(Boolean.valueOf(true)));
        }
        return signDto;
    }

    private SignDto convertToSignDto(List<DayRewardModel> dayRewardModels, Integer signedDays) {
        SignDto signDto = new SignDto();
        signDto.setPeriodDays(this.signConfig.getCircle());
        signDto.setPeriodRewardGold(this.signConfig.getCircleReward());
        signDto.setSignDays(signedDays);
        ArrayList signDaysDtoList = Lists.newArrayList();
        dayRewardModels.forEach(dayRewardModel -> signDaysDtoList.add(this.convertToSignDaysDto(signedDays, (DayRewardModel)dayRewardModel)));
        signDaysDtoList.removeIf(signDaysDto -> 0 == signDaysDto.getDay());
        signDto.setSignDaysDtoList((List)signDaysDtoList);
        return signDto;
    }

    private ActivitySignLog convertToActivitySignLog(Long userId, DayRewardModel dayRewardModel) {
        ActivitySignLog signLog = new ActivitySignLog();
        signLog.setId(this.sequenceCreater.nextLongId());
        signLog.setUserId(userId);
        int reward = dayRewardModel.getReward() + dayRewardModel.getExtraReward();
        signLog.setReward(new BigDecimal(reward));
        return signLog;
    }

    private SignDaysDto convertToSignDaysDto(Integer finalSignedDays, DayRewardModel dayRewardModel) {
        SignDaysDto signDaysDto = new SignDaysDto();
        signDaysDto.setDay(dayRewardModel.getDay());
        signDaysDto.setHasExtraGolds(dayRewardModel.getHasExtra());
        signDaysDto.setGolds(dayRewardModel.getReward());
        signDaysDto.setExtraGolds(dayRewardModel.getExtraReward());
        signDaysDto.setStatus(Integer.valueOf(dayRewardModel.getDay() <= finalSignedDays ? 1 : 0));
        return signDaysDto;
    }

    private Integer getSignedDays(Long userId) {
        List signLogs = this.signLogMapper.listByUserId(userId);
        Integer signedDays = 0;
        Date currentDate = DateUtils.getClearDate((Date)new Date());
        boolean isSignToday = false;
        for (int i = 0; i < signLogs.size(); ++i) {
            boolean isDateSame;
            Date signDate = DateUtils.getClearDate((Date)((ActivitySignLog)signLogs.get(i)).getCreateTime());
            if (i == 0) {
                isSignToday = DateUtils.getDiffSeconed((Date)signDate, (Date)currentDate, (boolean)Boolean.FALSE) == 0L;
            }
            int calDays = isSignToday ? -i : -i - 1;
            Date todaySignDate = DateUtils.addField((Date)currentDate, (int)5, (int)calDays);
            boolean bl = isDateSame = DateUtils.getDiffSeconed((Date)signDate, (Date)todaySignDate, (boolean)Boolean.FALSE) == 0L;
            if (!isDateSame) break;
            Integer n = signedDays;
            Integer n2 = signedDays = Integer.valueOf(signedDays + 1);
        }
        if (0 == signedDays) {
            return signedDays;
        }
        return 0 == signedDays % this.signConfig.getCircle() ? this.signConfig.getCircle() : signedDays % this.signConfig.getCircle();
    }

    private Integer nextSignDayBySignedDays(Integer signedDays) {
        return signedDays.equals(this.signConfig.getCircle()) ? 1 : signedDays + 1;
    }

    @Override
    public SignAndInfoDTO signAndInfo(Long userId) {
        if (null == userId) {
            log.error("\u8bf7\u6c42\u7b7e\u5230\u63a5\u53e3\u5931\u8d25,\u7528\u6237id\u4e3a\u7a7a");
            return null;
        }
        if (!this.signByDay(userId)) {
            log.error("\u8bf7\u6c42\u7b7e\u5230\u63a5\u53e3\u5931\u8d25,\u7528\u6237id:{}", (Object)userId);
            return null;
        }
        SignFacadeDto signFacadeDto = this.getSignInfo(userId);
        if (Objects.isNull(signFacadeDto)) {
            log.error("\u83b7\u53d6\u7b7e\u5230\u540e\u7b7e\u5230\u4fe1\u606f\u4e3a\u7a7a,\u7528\u6237id:{}", (Object)userId);
            return null;
        }
        SignAndInfoDTO signResultDTO = new SignAndInfoDTO();
        signResultDTO.setSignDays(signFacadeDto.getSignDays());
        signResultDTO.setRewardGold(signFacadeDto.getRewardGold());
        return signResultDTO;
    }
}

