/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.service.task.impl;

import com.bxm.fossicker.activity.config.DayGoldConfig;
import com.bxm.fossicker.activity.domain.ActivityDayGoldMapper;
import com.bxm.fossicker.activity.domain.ActivityTaskMapper;
import com.bxm.fossicker.activity.enums.DayGoldObtainStatusEnum;
import com.bxm.fossicker.activity.enums.DayGoldRedPacketStatusEnum;
import com.bxm.fossicker.activity.facade.TaskFacadeService;
import com.bxm.fossicker.activity.facade.enums.ActivityFacadeEnum;
import com.bxm.fossicker.activity.facade.model.ActivityTaskFacadeDTO;
import com.bxm.fossicker.activity.facade.model.ActivityUserTaskFacadeDTO;
import com.bxm.fossicker.activity.facade.model.DayGoldFacadeDto;
import com.bxm.fossicker.activity.model.dto.DayGoldDto;
import com.bxm.fossicker.activity.model.dto.DayGoldRedPacketDto;
import com.bxm.fossicker.activity.model.vo.ActivityDayGold;
import com.bxm.fossicker.activity.model.vo.ActivityTask;
import com.bxm.fossicker.activity.model.vo.ActivityUserTask;
import com.bxm.fossicker.activity.service.dispatcher.ActivityActionDispatcher;
import com.bxm.fossicker.activity.service.task.TaskService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskFacadeServiceImpl
implements TaskFacadeService {
    private static final Logger log = LogManager.getLogger(TaskFacadeServiceImpl.class);
    @Autowired
    private ActivityDayGoldMapper dayGoldMapper;
    @Autowired
    private ActivityTaskMapper taskMapper;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private DayGoldConfig dayGoldConfig;
    private TaskService taskService;
    @Autowired
    private ActivityActionDispatcher activityActionDispatcher;

    private TaskService getTaskService() {
        if (null == this.taskService) {
            this.taskService = (TaskService)SpringContextHolder.getBean(TaskService.class);
        }
        return this.taskService;
    }

    public Boolean complete(Long userId, ActivityFacadeEnum activityFacadeEnum) {
        if (null == userId || null == activityFacadeEnum) {
            return false;
        }
        switch (activityFacadeEnum.getType()) {
            case 0: {
                this.getTaskService().taskComplete(userId, activityFacadeEnum.name());
                break;
            }
            case 1: {
                this.activityActionDispatcher.getByActivityName(activityFacadeEnum.name()).reward(userId);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Async
    @Transactional
    public void createDayGold(Long userId) {
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237[{}]\u521b\u5efa\u5929\u5929\u9886\u73b0\u91d1\u6d3b\u52a8", (Object)userId);
        }
        if (null != userId && this.dayGoldMapper.count(userId) == 0) {
            this.createRedPacket(userId);
        }
    }

    public DayGoldFacadeDto dayGoldInfo(Long userId) {
        DayGoldDto dayGoldDto = this.getTaskService().dayGoldInfo(userId);
        if (Objects.nonNull(dayGoldDto)) {
            BigDecimal goldNum = BigDecimal.ZERO;
            for (DayGoldRedPacketDto dayGoldRedPacketDto : dayGoldDto.getDayGoldRedPacketDtoList()) {
                if (dayGoldRedPacketDto.getStatus().intValue() != DayGoldRedPacketStatusEnum.WAIT_OBTAIN.ordinal()) continue;
                goldNum = dayGoldRedPacketDto.getGoldNum();
                break;
            }
            return DayGoldFacadeDto.builder().goldNum(Long.valueOf(goldNum.longValue())).unObtain(dayGoldDto.getUnObtain()).build();
        }
        return null;
    }

    public ActivityUserTaskFacadeDTO queryUserTask(Long userId, ActivityFacadeEnum activityFacadeEnum) {
        ActivityUserTask activityUserTask = this.taskMapper.query(userId, activityFacadeEnum.name());
        if (Objects.nonNull(activityUserTask)) {
            ActivityUserTaskFacadeDTO dto = new ActivityUserTaskFacadeDTO();
            BeanUtils.copyProperties((Object)activityUserTask, (Object)dto);
            return dto;
        }
        return null;
    }

    public ActivityTaskFacadeDTO queryById(Long taskId) {
        ActivityTask activityTask = this.taskMapper.queryById(taskId);
        if (Objects.nonNull(activityTask)) {
            ActivityTaskFacadeDTO dto = new ActivityTaskFacadeDTO();
            BeanUtils.copyProperties((Object)activityTask, (Object)dto);
            return dto;
        }
        return null;
    }

    private void createRedPacket(Long userId) {
        ArrayList dayGoldList = Lists.newArrayList();
        Date currentDate = new Date();
        for (int day = 1; day <= 7; ++day) {
            dayGoldList.add(ActivityDayGold.builder().id(this.sequenceCreater.nextLongId()).userId(userId).dayNum(Integer.valueOf(day)).status(Integer.valueOf(DayGoldObtainStatusEnum.NOT_OBTAIN.ordinal())).expectDate(DateUtils.addField((Date)DateUtils.getClearDate((Date)currentDate), (int)5, (int)(day - 1))).awardType(this.dayGoldConfig.getType()).awardAmount(new BigDecimal((Integer)this.dayGoldConfig.getAmount().get(day - 1))).createTime(currentDate).build());
        }
        this.dayGoldMapper.batchInsert((List)dayGoldList);
    }
}

