package com.bxm.fossicker.base.facade.model;

import com.bxm.fossicker.base.param.EquipmentBaseInfo;
import com.bxm.fossicker.base.vo.CommonEquipmentApp;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class EquipmentDTO extends EquipmentBaseInfo {

    @ApiModelProperty("服务端的设备唯一标识，客户端在第一次上报时，id为空，在上报完毕得到id后将其缓存至本地，下次上报携带id进行更新(在基础参数中作为devcId)")
    private String id;

    @ApiModelProperty("是否开启消息通知 否:false")
    private boolean enableNotification;

    @ApiModelProperty("手机型号")
    private String phoneModel;

    @ApiModelProperty("操作系统版本")
    private String operatingSystem;

    @ApiModelProperty(value = "通用参数：当前APP的上线版本", required = true)
    private String curVer;

    private List<CommonEquipmentApp> apps;

}