package com.bxm.fossicker.base.config;

import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Map;

@ConfigurationProperties(prefix = "base.config")
@Data
@Component
public class BaseInfoPeroperties {

    private String shareCommodityUrl;

    private String ticketCommodityUrl;

    /**
     * 后端API域名
     */
    private String serverHost;

    /**
     * 上报埋点的URL地址
     */
    private String reportPointUrl;

    /**
     * 上报埋点的版本，如果具体埋点未提供版本则采用此值
     */
    private String reportPointVersion;

    private boolean huaweiSwich;

    /**
     * 广告开关
     */
    @Deprecated
    private Map<String, Boolean> advertisementSwitch = Maps.newHashMap();

    /**
     * 1.5.0之后的广告开关信息
     * [
     * {
     * "channel": "huawei",
     * "switchStatus": "true",
     * "versions": ["1.4.1", "1.4.2"]
     * }
     * ]
     */
    private String advertisementSwitchInfo;
}
