package com.bxm.fossicker.base.config;

import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 客户端配置
 *
 * @author liujia
 * @date 2020/03/11 15:47
 */
@Data
@ConfigurationProperties(prefix = "client.config")
@Component
public class ClientConfigProperties {
    /**
     * 客户端公共配置
     */
    private Map<String, String> commonKeys = Maps.newHashMap();

    /**
     * 安卓特有的客户端配置
     */
    private Map<String, String> androidKeys = Maps.newHashMap();

    /**
     * ios特有的客户端配置
     */
    private Map<String, String> iosKeys = Maps.newHashMap();

    /**
     * web端特有的客户端配置
     */
    private Map<String, String> webKeys = Maps.newHashMap();
}
