package com.bxm.fossicker.base.enums;

/**
 * 客户端设备标识枚举类
 * Created by Administrator on 2018/3/8.
 */
public enum EquipmentEnum {

    ANDROID_IMEI("imei", "android：表示唯一值，不同手机返回不同（ D EVICE_ID/MAC 等 ），本文档中主要用于表示设备唯一码。重置系统不会重置，需要申请权限后获取"),

    ANDROID_IMEI_MD5("imeiMd5", "android imei MD5加密结果"),

    ANDROID_ID("androidId", "android：安卓系统初始化时创建一次，重置系统会被重置"),

    ANDROID_ID_MD5("androidIdMd5", "android id MD5加密结果"),

    ANDROID_UUID("androidUuid", "android：每次即生成的uuid"),

    IOS_IDFA("idfa", "ios：中的 广告追踪 I D ， 用户可进行重置或阻止追踪 （返回 16 个 0 ）"),

    IOS_IDFA_MD5("idfaMd5", "idfa MD5加密结果"),

    IOS_DEVICE_ID("iosId", "ios：本文档中特指 iOS 设备号，由 App 创建后上传，可保证同一设备同一 App 重复安装仍保持一致"),

    ENABLE_NOTIFICATION("enableNotification", "是否开启消息通知 否:false"),

    PHONE_MODEL("phoneModel", "手机型号"),

    OPERATING_SYSTEM("operatingSystem", "操作系统版本"),

    CLIENT_VERSION("curVer", "客户端版本");

    private String type;

    private String desc;

    EquipmentEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getLevelEunm(String type) {
        for (EquipmentEnum levelEnum : EquipmentEnum.values()) {
            if (levelEnum.getType().equals(type)) {
                return levelEnum.getDesc();
            }
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

}
