package com.bxm.fossicker.base.service;

import com.bxm.fossicker.base.entity.AppChannelVersion;
import com.bxm.fossicker.base.facade.param.AppVersionParam;
import com.bxm.fossicker.base.facade.vo.AppChannelVersionVO;

/**
 * @Author: pf.w
 * @Date: 2019/8/7 17:04
 */

public interface AppVersionService {

    /**
     * 根据请求参数获取可用的版本更新
     * @param param
     * @return
     */
    AppChannelVersionVO getVersion(AppVersionParam param);


    /**
     * 根据版本号，获取当前版本是否处于提包状态
     * @param param
     * @return True 提包中
     */
    Boolean getAuditStatus(AppVersionParam param);

    /**
     * 获取最新版本信息
     * @param mobileType
     * @param chnl
     * @return
     */
    AppChannelVersion getNewversionInfo(int mobileType, String chnl);
}
