package com.bxm.fossicker.base.service;

import com.bxm.fossicker.base.dto.EquipmentInfoDto;
import com.bxm.fossicker.base.facade.model.EquipmentDTO;
import com.bxm.fossicker.base.param.EquipmentParam;

public interface EquipmentService {

    /**
     * 上报设备信息，并返回静默用户ID
     *
     * @param param 设备信息
     * @return 设备信息与静默用户ID信息
     */
    EquipmentInfoDto createMutedUser(EquipmentParam param);

    /**
     * 根据设备唯一标识获取设备信息
     *
     * @param deviceId 设备ID
     * @return 设备信息
     */
    EquipmentDTO get(String deviceId);

    /**
     * 是否开启推送 false：否
     *
     * @param deviceId
     * @return
     */
    boolean checkHasOpenPush(String deviceId);
}
