package com.bxm.fossicker.base.service;

import com.bxm.fossicker.base.param.PopUpWindowsClickParam;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.param.PopUpWindowsListParam;
import com.bxm.fossicker.base.vo.PopUpWindowsVO;
import com.bxm.newidea.component.vo.Message;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 弹窗相关接口
 * @Author: Gonzo
 * @date  2020-03-13 11:23
 * @since 1.6.0
 */
public interface PopUpWindowsService {

    /**
     * 根据区域获取弹窗列表
     * @param param param
     * @return 弹窗列表
     */
    List<PopUpWindowsVO> list(PopUpWindowsListParam param);


    /**
     * 关闭天窗事件上报
     * @param param param
     * @return 关闭是否成功
     */
    Message close(@RequestBody PopUpWindowsCloseParam param);

    /**
     * 点击事件上报
     * 已失效，上报信息用埋点
     * @param param param
     * @return 上报是否成功
     */
    @Deprecated
    Message click(@RequestBody PopUpWindowsClickParam param);
}
