package com.bxm.fossicker.base.service;

import com.bxm.fossicker.base.param.PopUpWindowsListParam;
import com.bxm.fossicker.base.vo.PopUpWindowsVO;

import java.util.List;

/**
 * @authoer Gonzo
 * @date 2019-09-03 13:44
 *
 * 弹窗处理接口
 *
 * 趣淘金弹窗
 * 按照优先级排列：
 * 1.用户画像弹窗：一个用户只弹一次
 * 2.新人弹窗：一个用户只弹一次
 * 3.版本升级弹窗：每次启动时检查新版本，若有新版本则弹，一天一次
 * 4.金币翻倍弹窗：金币获得时弹出
 * 5.任务弹窗：用户每次启动app进入首页时弹出，一天只弹一次，与新人弹窗不同时触发
 * 6.邀请弹窗：用户启动应用后，点击“我的”，若用户当日已签到，则弹出弹窗。每天只弹一次。
 */
public interface PopWindowsProcessService {

    /**
     * 调用过滤器过滤弹窗 并填充弹窗数据
     * @param popUpWindows
     * @param param
     */
    void popWindowsProcess(List<PopUpWindowsVO> popUpWindows, PopUpWindowsListParam param);

    /**
     * 处理弹窗点击关闭事件
     * @param userId
     * @param type
     */
    void close(Long userId, Byte type);
}
