package com.bxm.fossicker.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.base.config.BaseInfoPeroperties;
import com.bxm.fossicker.base.dto.AdvertisementSwitchInfo;
import com.bxm.fossicker.base.service.AppService;
import com.bxm.fossicker.vo.BasicParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;


@Slf4j
@Service
public class AppServiceImpl implements AppService {

    @Autowired
    private BaseInfoPeroperties baseInfoPeroperties;


    @Override
    public Boolean advertisementSwitch(BasicParam basicParam) {

        // android
        if (basicParam.getPlatform() == 1) {
            List<AdvertisementSwitchInfo> switchInfos = JSON.parseArray(baseInfoPeroperties.getAdvertisementSwitchInfo(),
                    AdvertisementSwitchInfo.class);

            if (CollectionUtils.isEmpty(switchInfos)) {
                log.info("未配置广告屏蔽信息");
                return Boolean.FALSE;
            }

            for (AdvertisementSwitchInfo switchInfo : switchInfos) {
                if (Objects.equals(switchInfo.getChannel(), basicParam.getChnl())) {
                    // 如果配置了为true
                    if (Objects.equals(switchInfo.getSwitchStatus(), Boolean.TRUE)
                            // 且配置了版本号
                            && !CollectionUtils.isEmpty(switchInfo.getVersions())) {
                        // 判断版本是否命中
                        return switchInfo.getVersions().stream()
                                .anyMatch(p -> Objects.equals(p, basicParam.getCurVer()));
                    }

                    // 一个渠道只能配一个，所以匹配渠道之后直接break
                    break;
                }
            }
        }

        return Boolean.FALSE;
    }
}
