package com.bxm.fossicker.base.service.impl;

import com.bxm.fossicker.base.entity.AppChannelVersion;
import com.bxm.fossicker.base.facade.AppVersionFacadeService;
import com.bxm.fossicker.base.facade.param.AppVersionParam;
import com.bxm.fossicker.base.facade.vo.AppChannelVersionVO;
import com.bxm.fossicker.base.service.AppVersionService;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 版本控制内部服务
 * @author zhaoxin
 */
@Service
public class AppVersionFacadeServiceImpl implements AppVersionFacadeService {

    private final AppVersionService appVersionService;

    @Autowired
    public AppVersionFacadeServiceImpl(AppVersionService appVersionService) {
        this.appVersionService = appVersionService;
    }

    @Override
    public Boolean getAuditStatus(AppVersionParam param) {
        return appVersionService.getAuditStatus(param);
    }

    @Override
    public AppChannelVersionVO getNewversion(AppVersionParam param) {
        AppChannelVersion appChannelVersion = appVersionService.getNewversionInfo(param.getPlatform(),param.getChnl());
        if(null != appChannelVersion && StringUtils.isNotEmpty(appChannelVersion.getDownloadLink())){
            return AppChannelVersionVO.builder()
                    .version(appChannelVersion.getVersion())
                    .downloadLink(appChannelVersion.getDownloadLink())
                    .isForce(new Byte("1"))
                    .build();
        }
        return null;
    }
}
