package com.bxm.fossicker.base.service.impl;

import com.bxm.fossicker.base.domain.AppVersionMapper;
import com.bxm.fossicker.base.entity.AppChannelVersion;
import com.bxm.fossicker.base.facade.param.AppVersionParam;
import com.bxm.fossicker.base.facade.vo.AppChannelVersionVO;
import com.bxm.fossicker.base.service.AppVersionService;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @Author: pf.w
 * @Date: 2019/8/7 17:04
 */
@Service
public class AppVersionServiceImpl implements AppVersionService {
    @Resource
    private AppVersionMapper appVersionMapper;

    @Override
    public AppChannelVersionVO getVersion(AppVersionParam param) {

        // 获取当前平台的所有版本更新信息（暂时不考虑渠道）
        List<AppChannelVersion> appChannelVersions = appVersionMapper.listEnableAppVersionInfo(param.getPlatform());

        // 过滤出可更新的版本
        Optional<AppChannelVersion> optionalAppChannelVersion = appChannelVersions.stream()
                // 暂时只比较版本是否高于
                .filter(p -> StringUtils.compareVersion(param.getCurVer(), p.getVersion()) < 0)
                // 根据版本排序，获取最大的可用的
                .sorted((p1, p2) -> StringUtils.compareVersion(p2.getVersion(), p1.getVersion()))
                .findFirst();

        if (optionalAppChannelVersion.isPresent()) {
            AppChannelVersion version = optionalAppChannelVersion.get();
            // 如果是强制更新
            if (Objects.nonNull(version.getIsForce()) && version.getIsForce().intValue() == 1) {
                // 判断当前版本是否符合强制更新范围（当前版本以及更低版本）
                if (StringUtils.compareVersion(param.getCurVer(), version.getForceVersion()) > 0) {
                    // 如果当前版本大于强制更新的版本 则不强制跟新
                    version.setIsForce((byte) 0);
                }
            }
        }

        return optionalAppChannelVersion.map(this::convert).orElse(null);

    }

    @Override
    public Boolean getAuditStatus(AppVersionParam param) {
        AppChannelVersion appChannelVersion = appVersionMapper.getEnableAppVersionByMobileTypeAndVersion(param.getPlatform(),
                param.getCurVer());

        if (appChannelVersion != null) {
            // 判断版本是否在提包状态
            return appChannelVersion.getStatus().intValue() == 1;
        }

        return Boolean.FALSE;
    }

    @Override
    public AppChannelVersion getNewversionInfo(int mobileType, String chnl) {
        return appVersionMapper.getNewversionInfo(mobileType,chnl);
    }

    /**
     * 转换对象
     * @param appChannelVersion
     * @return
     */
    private AppChannelVersionVO convert(AppChannelVersion appChannelVersion) {
        AppChannelVersionVO appChannelVersionVO = AppChannelVersionVO.builder().build();
        BeanUtils.copyProperties(appChannelVersion, appChannelVersionVO);
        return appChannelVersionVO;
    }
}
