package com.bxm.fossicker.base.service.impl;

import com.bxm.fossicker.base.config.ClientConfigProperties;
import com.bxm.fossicker.base.service.ClientConfigService;
import com.bxm.fossicker.enums.PlatformEnum;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 获取客户端配置
 */
@Service
public class ClientConfigServiceImpl implements ClientConfigService {

    private final ClientConfigProperties clientConfigProperties;

    @Autowired
    public ClientConfigServiceImpl(ClientConfigProperties clientConfigProperties) {
        this.clientConfigProperties = clientConfigProperties;
    }

    @Override
    public Map<String, String> getAllConfig(Integer platform) {
        Map<String, String> specialMap = Maps.newHashMap();

        if (platform == PlatformEnum.ANDROID.getCode()) {
            specialMap = clientConfigProperties.getAndroidKeys();
        } else if (platform == PlatformEnum.IOS.getCode()) {
            specialMap = clientConfigProperties.getIosKeys();
        } else if (platform == PlatformEnum.WEB.getCode()) {
            specialMap = clientConfigProperties.getWebKeys();
        }

        Map<String, String> resultMap = new HashMap<>();
        resultMap.putAll(clientConfigProperties.getCommonKeys());
        resultMap.putAll(specialMap);

        return resultMap;
    }
}
