package com.bxm.fossicker.base.service.impl;

import com.bxm.fossicker.base.service.impl.popup.interfacies.PopUpHandler;
import com.bxm.fossicker.vo.BasicParam;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;

/**
 * @author Gonzo
 * @date 2019-10-10 15:40
 */
@Service
@Slf4j
public class CommonPopUpWindowsServiceImpl implements ApplicationContextAware, ApplicationRunner, CommonPopUpWindowsService {

    public static final Map<Class, PopUpHandler> POP_UP_HANDLER_HASH_MAP = Maps.newHashMap();

    private ApplicationContext applicationContext;


    @Override
    public <R> R handle(BasicParam param) {

        PopUpHandler handler = POP_UP_HANDLER_HASH_MAP.get(param.getClass());

        if (Objects.isNull(handler)) {
            log.warn("类型: {} 没有对应的handler处理类", param.getClass());
            return (R) Lists.newArrayList();
        }

        return (R) handler.handle(param);
    }


    @Override
    public void run(ApplicationArguments args) throws Exception {
        Collection<PopUpHandler> popUpHandlers = applicationContext.getBeansOfType(PopUpHandler.class).values();

        popUpHandlers.forEach(p -> {
            POP_UP_HANDLER_HASH_MAP.put(p.support(), p);
        });

    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
