package com.bxm.fossicker.base.service.impl;

import com.bxm.fossicker.base.facade.model.EquipmentDTO;
import com.bxm.fossicker.base.facade.service.EquipmentFacadeService;
import com.bxm.fossicker.base.param.EquipmentParam;
import com.bxm.fossicker.base.service.EquipmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Author: pf.w
 * @Date: 2019/10/28 14:24
 */
@Service
public class EquipmentFacadeServiceImpl implements EquipmentFacadeService {

    @Autowired
    private EquipmentService equipmentService;

    @Override
    public EquipmentDTO getByDeviceId(String deviceId) {
        return equipmentService.get(deviceId);
    }

    @Override
    public boolean hasEnablePush(String deviceId) {
        return equipmentService.checkHasOpenPush(deviceId);
    }

    @Override
    public String createEquipment(EquipmentParam param) {
        return equipmentService.createMutedUser(param).getEquipmentId();
    }
}
