package com.bxm.fossicker.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.fossicker.base.config.BaseInfoPeroperties;
import com.bxm.fossicker.base.service.PoinstAsyncReportService;
import com.bxm.newidea.component.service.BaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
public class PointAsyncReportServiceImpl extends BaseService implements PoinstAsyncReportService {

    private final HttpClientService httpClientService;

    private final BaseInfoPeroperties baseInfoPeroperties;

    @Autowired
    public PointAsyncReportServiceImpl(HttpClientService httpClientService, BaseInfoPeroperties baseInfoPeroperties) {
        this.httpClientService = httpClientService;
        this.baseInfoPeroperties = baseInfoPeroperties;
    }

    @Override
    @Async
    public void save(Map<String, String> data) {
        try {
            data.computeIfAbsent("v", k -> baseInfoPeroperties.getReportPointVersion());
            httpClientService.doGet(baseInfoPeroperties.getReportPointUrl(), data);
        } catch (Exception e) {
            logger.error("埋点上报失败，埋点内容：[{}]", JSON.toJSONString(data));
            logger.error(e.getMessage(), e);
        }
    }
}
