package com.bxm.fossicker.base.service.impl;

import com.bxm.fossicker.base.facade.PointReportFacadeService;
import com.bxm.fossicker.base.facade.param.PointParam;
import com.bxm.fossicker.base.service.PoinstAsyncReportService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class PointReportFacadeServiceImpl implements PointReportFacadeService {

    private final PoinstAsyncReportService poinstAsyncReportService;

    @Autowired
    public PointReportFacadeServiceImpl(PoinstAsyncReportService poinstAsyncReportService) {
        this.poinstAsyncReportService = poinstAsyncReportService;
    }

    @Override
    public void add(PointParam param) {
        log.debug("report point:{}", param);

        poinstAsyncReportService.save(param.getMap());
    }
}
