package com.bxm.fossicker.base.service.impl;

import com.bxm.fossicker.base.config.BaseInfoPeroperties;
import com.bxm.fossicker.base.facade.service.ShortLinkFacadeService;
import com.bxm.fossicker.base.param.CommodityShareParam;
import com.bxm.fossicker.base.service.ShortLinkService;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Author: pf.w
 * @Date: 2019/10/30 17:35
 */
@Service
public class ShortLinkFacadeServiceImpl implements ShortLinkFacadeService {
    @Autowired
    private ShortLinkService shortLinkService;

    @Autowired
    private BaseInfoPeroperties baseInfoPeroperties;
    @Override
    public String getGoodsShortLink(Long goodsId) {
        String shareBaseUrl = baseInfoPeroperties.getTicketCommodityUrl();
        StringBuilder stringBuilder = new StringBuilder(shareBaseUrl);
        if (null != goodsId) {
            stringBuilder.append("goodsId=").append(goodsId.toString());
        }
        return stringBuilder.toString();
    }
}
