package com.bxm.fossicker.base.service.impl.popup;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.service.impl.popup.interfacies.PopUpWindowsInterceptor;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.Objects;

/**
 * 弹窗过滤器
 * 定义过滤弹窗、记录弹窗弹出次数等操作
 * @author Gonzo
 * @date 2019-10-10 14:10
 */
public abstract class AbstractPopUpWindowsInterceptor implements PopUpWindowsInterceptor {

    protected Logger log = LoggerFactory.getLogger(getClass());

    @Autowired
    protected RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public void invoke(FilterPopUpWindowsBO popUpWindows) {

        if (Objects.isNull(popUpWindows) || CollectionUtils.isEmpty(popUpWindows.getPopUpWindows())) {
            return;
        }

        try {
            doInvoke(popUpWindows);

        } catch(Exception e) {

            log.error("执行弹窗过滤出错", e);
        }

    }

    /**
     * 过滤不符合规则的弹窗、记录弹窗数据等操作
     * @param popUpWindows
     */
    protected abstract void doInvoke(FilterPopUpWindowsBO popUpWindows);

}
