package com.bxm.fossicker.base.service.impl.popup;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.interfacies.PopUpWindowsInterceptor;
import com.bxm.fossicker.base.service.impl.popup.interfacies.PopUpWindowsProcess;
import com.google.common.collect.Lists;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;
import java.util.Objects;

/**
 * 弹窗拦截器链
 * @author Gonzo
 * @date 2019-10-10 14:07
 */
@Component
public class PopUpWindowsInterceptorChain implements PopUpWindowsInterceptor {

    private static final  List<PopUpWindowsInterceptor> INTERCEPTORS = Lists.newArrayList();

    @Override
    public void invoke(FilterPopUpWindowsBO popUpWindows) {

        for (PopUpWindowsInterceptor interceptor : INTERCEPTORS) {
            interceptor.invoke(popUpWindows);
        }
    }


    @EventListener(ContextRefreshedEvent.class)
    public void onApplicationStartedEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();

        Collection<PopUpWindowsInterceptor> filters = applicationContext.getBeansOfType(PopUpWindowsInterceptor.class)
                .values();

        filters.forEach(p -> {
            PopUpProcess popUpProcess = AnnotationUtils.getAnnotation(AopUtils.getTargetClass(p),
                    PopUpProcess.class);

            if (Objects.nonNull(popUpProcess)) {
                INTERCEPTORS.add(p);

                // 如果是指定类型的弹窗处理器，则根据注解设置指定的处理类型
                if (p instanceof PopUpWindowsProcess) {
                    ((PopUpWindowsProcess) p).setProcessSupportPopUp(popUpProcess.special());
                }
            }
        });

        // 排序
        INTERCEPTORS.sort((p1, p2) -> {
            PopUpProcess popUpProcess1 = AnnotationUtils.getAnnotation(AopUtils.getTargetClass(p1),
                    PopUpProcess.class);

            PopUpProcess popUpProcess2 = AnnotationUtils.getAnnotation(AopUtils.getTargetClass(p2),
                    PopUpProcess.class);

            return Integer.compare(popUpProcess1.order().getOrder(), popUpProcess2.order().getOrder());
        });

    }

}
