package com.bxm.fossicker.base.service.impl.popup.annotation;

import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import org.springframework.stereotype.Component;

import java.lang.annotation.*;

/**
 * 弹窗处理类
 * @author Gonzo
 * @date 2019-10-09 18:12
 */

@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Component
public @interface PopUpProcess {

    /**
     * 只有公共处理类才可以使用当前属性进行设置
     * 如果是指定某个类型弹窗的处理，则使用 {@link this#special} 进行特殊指定
     * 支持的弹窗类型数组
     * 默认支持所有类型
     *
     * 其实这个字段暂时还没有支持的，需要再interceptor里面在调用的时候，动态的判断支持的类型
     * 不过现在没有这个需求，就先晾着吧。
     * @return 支持的弹窗类型数组
     */
    PopUpEnum[] value() default {};

    /**
     * 支持的弹窗类型
     * 对于指定某个类型弹窗的处理，使用当前属性进行设置
     * 而如果是公共处理类，则使用 {@link this#value} 进行赋值指定
     * @return 支持的弹窗
     */
    PopUpEnum special() default PopUpEnum.NONE;

    /**
     * 处理顺序
     * 给一些特殊处理器一个最后执行的机会
     * 执行顺序从小到大
     * 默认是通用处理器的顺序
     * @return
     */
    PopUpProcessOrderEn order() default PopUpProcessOrderEn.GENERAL;

}
