package com.bxm.fossicker.base.service.impl.popup.interceptor;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.facade.param.AppVersionParam;
import com.bxm.fossicker.base.service.AppVersionService;
import com.bxm.fossicker.base.service.impl.popup.AbstractPopUpWindowsInterceptor;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 审核过滤器
 * @author Gonzo
 * @date 2019-10-10 14:07
 */
@Slf4j
@PopUpProcess
public class AuditPopUpWindowsInterceptor extends AbstractPopUpWindowsInterceptor {

    @Autowired
    private AppVersionService appVersionService;

    @Override
    protected void doInvoke(FilterPopUpWindowsBO popUpWindows) {
        // 判断是否在审核中
        AppVersionParam param = new AppVersionParam();
        BeanUtils.copyProperties(popUpWindows.getParam(), param);

        Boolean auditStatus = appVersionService.getAuditStatus(param);

        if (auditStatus) {
            if (log.isDebugEnabled()) {
                log.debug("审核中，过滤掉所有不在审核中展示的弹窗");
            }
            popUpWindows.getPopUpWindows().removeIf(p -> p.getAuditHide().intValue() == 1);
        }

    }

}
