package com.bxm.fossicker.base.service.impl.popup.interceptor;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.service.impl.popup.AbstractPopUpWindowsInterceptor;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 互斥过滤器
 * @author Gonzo
 * @date 2019-10-10 14:07
 */
@PopUpProcess(order = PopUpProcessOrderEn.EXCLUSION)
public class ExclusionPopUpWindowsInterceptor extends AbstractPopUpWindowsInterceptor {

    @Override
    protected void doInvoke(FilterPopUpWindowsBO popUpWindows) {


        List<CommonPopUpWindowsEntry>removeList = popUpWindows.getPopUpWindows().stream().filter(p -> {
            // 返回是否需要过滤
            if (StringUtils.isBlank(p.getExclusionJson())) {
                return false;
            }

            Exclusion exclusion = JSON.parseObject(p.getExclusionJson(), Exclusion.class);

            if (Objects.isNull(exclusion) || Objects.isNull(exclusion.getType())) {
                return false;
            }

            switch (exclusion.getType()) {
                case 1: // 当前弹窗与某些类型弹窗互斥
                    if (CollectionUtils.isEmpty(exclusion.getExclusionPopUpTypes())) {
                        return false;
                    }

                    return popUpWindows.getPopUpWindows().stream()
                            .filter(p1 -> exclusion.getExclusionPopUpTypes().stream()
                                    .filter(p2 -> Objects.equals( p1.getType().intValue(), p2.intValue()))
                                    .count() > 0)
                            .count() > 0;

                case 2:  // 与某些弹窗id互斥
                    if (CollectionUtils.isEmpty(exclusion.getExclusionPopUpIds())) {
                        return false;
                    }

                    return popUpWindows.getPopUpWindows().stream()
                            .filter(p1 -> exclusion.getExclusionPopUpIds().stream()
                                    .filter(p2 -> Objects.equals( p1.getId().longValue(), p2.longValue()))
                                    .count() > 0)
                            .count() > 0;

                case 3: //与某种弹窗分类互斥
                    if (CollectionUtils.isEmpty(exclusion.getExclusionCategories())) {
                        return false;
                    }


                    return popUpWindows.getPopUpWindows().stream()
                            .filter(p1 -> exclusion.getExclusionCategories().stream()
                                    .filter(p2 -> Objects.equals(p1.getCategory().intValue(), p2.intValue()))
                                    .count() > 0)
                            .count() > 0;
                 default:
            }

            return false;
        }).peek(p -> {
            if (log.isDebugEnabled()) {
                log.debug("互斥过滤器, 过滤弹窗: {}", p.getName());
            }
        }).collect(Collectors.toList());

        popUpWindows.getPopUpWindows().removeAll(removeList);

    }
}

/**
 * {
 * 	type: 1,
 * 	exclusionPopUpTypes: [],
 * 	exclusionPopUpIds: []
 * }
 */

/**
 * 如果出现符合互斥类型的则当前弹窗不弹
 */
@Data
class Exclusion {

    /**
     * 互斥类型 1：当前弹窗与某些类型弹窗互斥 2：与某些弹窗id互斥 3：与某种分类弹窗互斥（1：系统弹窗 | 2：功能性弹窗 | 3：活动弹窗）
     */
    private Integer type;

    /**
     * 互斥的弹窗类型
     */
    private List<Integer> exclusionPopUpTypes;

    /**
     * 互斥的弹窗id
     */
    private List<Long> exclusionPopUpIds;

    /**
     * 互斥的弹窗分类
     */
    private List<Integer> exclusionCategories;


}
