package com.bxm.fossicker.base.service.impl.popup.interceptor;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.bo.UserPopUpedBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.service.impl.popup.AbstractPopUpWindowsInterceptor;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 过滤一些达到某种条件出发才关闭的弹窗
 * 对于一些弹窗，是在达成条件之后才关闭，和弹出次数又是不同的维度，所以这里统一处理
 * @author Gonzo
 * @date 2019-10-10 14:07
 */
@PopUpProcess
public class FinalClosePopUpWindowsInterceptor extends AbstractPopUpWindowsInterceptor {

    @Override
    protected void doInvoke(FilterPopUpWindowsBO popUpWindows) {

        // 缓存记录弹出次数并过滤已经达到次数的
        List<CommonPopUpWindowsEntry> removeList = popUpWindows.getPopUpWindows().stream().
                filter(p -> {

                    if (Objects.nonNull(popUpWindows.getParam().getUserId())) {

                        UserPopUpedBO userPopUpedBO = popUpWindows.getPopUpedInfo().get(Objects.toString(p.getId()));

                        // 判断用户是否永久关闭
                        return Objects.nonNull(userPopUpedBO) && userPopUpedBO.getFinalClose();
                    }
                    return false;
                })
                .peek(p -> {
                    if (log.isDebugEnabled()) {
                        log.debug("条件达成过滤器，过滤弹窗: {}", p.getName());
                    }
                })
                .collect(Collectors.toList());

        popUpWindows.getPopUpWindows().removeAll(removeList);

    }

}
