package com.bxm.fossicker.base.service.impl.popup.interceptor;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.service.impl.popup.AbstractPopUpWindowsInterceptor;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.constant.UserRedisKeyConstant;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 用户类型过滤器
 * @author Gonzo
 * @date 2019-10-10 14:07
 */
@PopUpProcess
public class LoginTypePopUpWindowsInterceptor extends AbstractPopUpWindowsInterceptor {

    @Override
    protected void doInvoke(FilterPopUpWindowsBO popUpWindows) {
        List<CommonPopUpWindowsEntry> commonPopUpWindowsEntryList = popUpWindows.getPopUpWindows();

        // 过滤用户类型
        List<CommonPopUpWindowsEntry> removeList = commonPopUpWindowsEntryList.stream().filter(p -> {

            // 返回是否需要过滤 true 过滤

            // 登录状态：0：全部 1：未登录 2：已登录
            if (Objects.isNull(p.getLoginType())) {
                return false;
            }

            String token = redisHashMapAdapter.get(UserRedisKeyConstant.HASH_USER_TOKEN, Objects.toString(popUpWindows.getParam().getUserId()), String.class);

            boolean result = p.getLoginType().intValue() == 0
                    // 如果为0 则不过滤
                    ? false :
                    p.getLoginType().intValue() == 1
                            // 如果为1，表示不需要登录 token不为null则过滤
                            ? StringUtils.isNotBlank(token)
                            // 如果需要登录 token为null则过滤
                            : StringUtils.isBlank(token);

            if (result) {
                if (log.isDebugEnabled()) {
                    log.debug("登录类型过滤器，过滤弹窗: {}", p.getName());
                }
            }

            return result;

        }).collect(Collectors.toList());


        commonPopUpWindowsEntryList.removeAll(removeList);
    }


}
