package com.bxm.fossicker.base.service.impl.popup.interceptor;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.bo.UserPopUpedBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.service.impl.popup.AbstractPopUpWindowsInterceptor;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 弹出时机过滤器
 * @author Gonzo
 * @date 2019-10-10 14:07
 */
@PopUpProcess(order = PopUpProcessOrderEn.OPPORTUNITY)
public class OpportunityWindowsInterceptor extends AbstractPopUpWindowsInterceptor {

    @Override
    protected void doInvoke(FilterPopUpWindowsBO popUpWindows) {
        List<CommonPopUpWindowsEntry> commonPopUpWindowsEntryList = popUpWindows.getPopUpWindows();

        // 弹出时机
        List<CommonPopUpWindowsEntry> removeList = commonPopUpWindowsEntryList.stream().filter(p -> {

            // 返回是否需要过滤

            // 如果没有配置则不过滤
            if (p.getPopUpOpportunity() == null
                    || Objects.equals(p.getPopUpOpportunity().intValue(), 0)) {
                return false;
            }


            // 记录次数
            UserPopUpedBO userPopUpedBO = popUpWindows.getPopUpedInfo().get(Objects.toString(p.getId()));

            // 如果次数满足配置的次数则不过滤
            if (Objects.nonNull(userPopUpedBO)
                    && Objects.nonNull(userPopUpedBO.getTimes())) {

                if (userPopUpedBO.getTimes().intValue() == p.getPopUpOpportunity().intValue()) {
                    return false;

                }
            }

            return true;
        }).peek(p -> {
            if (log.isDebugEnabled()) {
                log.debug("用户类型过滤器，过滤弹窗: {}", p.getName());
            }
        }).collect(Collectors.toList());


        commonPopUpWindowsEntryList.removeAll(removeList);
    }


}
