package com.bxm.fossicker.base.service.impl.popup.interceptor;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.service.impl.popup.AbstractPopUpWindowsInterceptor;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 平台过滤器
 * @author Gonzo
 * @date 2019-10-10 14:07
 */
@Slf4j
@PopUpProcess
public class PlatformPopUpWindowsInterceptor extends AbstractPopUpWindowsInterceptor {

    @Override
    protected void doInvoke(FilterPopUpWindowsBO popUpWindows) {
        // 缓存记录弹出次数并过滤已经达到次数的
        List<CommonPopUpWindowsEntry> removeList = popUpWindows.getPopUpWindows().stream().
                filter(p -> {

                    // 返回是否过滤 true 是

                    // 如果为0则表示所有平台
                    if (Objects.isNull(p.getPlatform()) || Objects.equals(p.getPlatform().intValue(), 0)) {
                        return false;
                    }

                    // 否则就判断是否是请求的平台了
                    return !Objects.equals(p.getPlatform().intValue(), popUpWindows.getParam().getPlatform());
                })
                .peek(p -> {
                    if (log.isDebugEnabled()) {
                        log.debug("平台过滤器，过滤弹窗: {}", p.getName());
                    }
                })
                .collect(Collectors.toList());

        popUpWindows.getPopUpWindows().removeAll(removeList);

    }

}
