package com.bxm.fossicker.base.service.impl.popup.interceptor;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.bo.UserPopUpedBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.service.impl.popup.AbstractPopUpWindowsInterceptor;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.newidea.component.tools.DateUtils;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 过滤弹出次数超限过滤器
 * @author Gonzo
 * @date 2019-10-10 14:07
 */
@PopUpProcess
public class TimesPopUpWindowsInterceptor extends AbstractPopUpWindowsInterceptor {

    @Override
    protected void doInvoke(FilterPopUpWindowsBO popUpWindows) {

        // 缓存记录弹出次数并过滤已经达到次数的
        List<CommonPopUpWindowsEntry> removeList = popUpWindows.getPopUpWindows().stream().
                filter(p -> {

                    // 返回是否过滤
                    if (Objects.isNull(p.getFrequencyType()) || Objects.isNull(p.getTimes())) {
                        return false;
                    }

                    UserPopUpedBO popUpedBO;
                    if (Objects.nonNull(popUpedBO = popUpWindows.getPopUpedInfo().get(Objects.toString(p.getId())))) {


                        Integer times = Objects.isNull(popUpedBO.getTimes()) ? 0 : popUpedBO.getTimes();

                        switch (p.getFrequencyType()) {
                            case 1: // 1：累计弹出次数
                                // 如果超过配置次数 则过滤
                                return times.intValue() >= p.getTimes().intValue();

                            case 2: // 2：每日弹出次数
                                // 如果是当日 times才有意义 否则的话，就会在次数记录拦截器里重新记录日期
                                if (DateUtils.isSameDay(popUpedBO.getDay(), new Date())) {
                                    // 如果超过配置次数 则过滤
                                    return Objects.nonNull(times) && times.intValue() >= p.getTimes().intValue();
                                }
                        }
                    }

                    return false;
                })
                .peek(p -> {
                    if (log.isDebugEnabled()) {
                        log.debug("弹出次数过滤器，过滤弹窗: {}", p.getName());
                    }
                })
                .collect(Collectors.toList());

        popUpWindows.getPopUpWindows().removeAll(removeList);

    }

}
