package com.bxm.fossicker.base.service.impl.popup.interceptor;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.bo.UserPopUpedBO;
import com.bxm.fossicker.base.constant.PopUpRedisConstant;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.service.impl.popup.AbstractPopUpWindowsInterceptor;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;

import java.util.Date;
import java.util.Objects;

/**
 * 记录弹出次数、弹窗总弹出次数过滤器
 * 对于需要手动点击关闭才算弹出的，具体处理类调用
 * 弹窗总弹出次数只有运营类弹窗才记录
 * #incrementTimes()方法即可
 * @author Gonzo
 * @date 2019-10-10 14:07
 */
@PopUpProcess(order = PopUpProcessOrderEn.RECORD_TIMES)
public class TimesRecodePopUpWindowsInterceptor extends AbstractPopUpWindowsInterceptor {


    @Override
    protected void doInvoke(FilterPopUpWindowsBO popUpWindows) {

        // 缓存记录弹出次数
        popUpWindows.getPopUpWindows().stream()
                .forEach(p -> {

                    // 是否是运营类弹窗 只有运营类弹窗才自动记录弹出次数
                    if (Objects.nonNull(p.getCategory())
                            && Objects.equals(p.getCategory().intValue(), 3)) {
                        // 增加弹窗的展示次数
                        redisHashMapAdapter.increment(PopUpRedisConstant.VIEWED_COUNT_POPUP_CACHE.copy(),
                                Objects.toString(p.getId()), 1);

                        UserPopUpedBO popUpedBO;
                        if (Objects.nonNull(popUpedBO = popUpWindows.getPopUpedInfo().get(Objects.toString(p.getId())))) {


                            int times = Objects.isNull(popUpedBO.getTimes()) ? 0 : popUpedBO.getTimes();

                            switch (p.getFrequencyType()) {
                                case 1: // 1：累计弹出次数
                                    popUpedBO.setTimes(times + 1);
                                    break;
                                case 2: // 2：每日弹出次数
                                    popUpedBO.setTimes(times + 1);
                                    popUpedBO.setDay(new Date());
                            }

                        } else {
                            popUpedBO = new UserPopUpedBO();
                            popUpedBO.setDay(new Date());
                            popUpedBO.setFinalClose(Boolean.FALSE);
                            popUpedBO.setPopUpId(p.getId());
                            popUpedBO.setType(p.getType());
                            popUpedBO.setCategory(p.getCategory());
                            popUpedBO.setTimes(1);

                            popUpWindows.getPopUpedInfo().put(Objects.toString(popUpedBO.getPopUpId()), popUpedBO);
                        }

                    }

                });
    }

}
