package com.bxm.fossicker.base.service.impl.popup.interceptor;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.service.impl.popup.AbstractPopUpWindowsInterceptor;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 版本过滤器
 *
 * @author Gonzo
 * @date 2019-10-10 14:07
 */
@PopUpProcess
public class VersionPopUpWindowsInterceptor extends AbstractPopUpWindowsInterceptor {

    @Override
    protected void doInvoke(FilterPopUpWindowsBO popUpWindows) {

        List<CommonPopUpWindowsEntry> removeList = popUpWindows.getPopUpWindows()
                .stream().filter(p -> {
                    // 返回是否过滤

                    if (StringUtils.isBlank(p.getVersionJson())
                            || StringUtils.isBlank(popUpWindows.getParam().getCurVer())) {
                        // 未配置版本信息 则不过滤
                        return false;
                    }

                    // json
                    VersionExclusion versionExclusion = JSON.parseObject(p.getVersionJson(), VersionExclusion.class);
                    if (Objects.isNull(versionExclusion) || Objects.isNull(versionExclusion.getType())) {
                        return false;
                    }

                    switch (versionExclusion.getType()) {
                        case 1:
                            // 1 小于等于指定一版本的展示
                            if (StringUtils.isBlank(versionExclusion.getSpecifiedVersion())) {
                                // 未配置指定版本 则不过滤
                                return false;
                            }
                            // 如果当前版本大于配置版本则过滤
                            return com.bxm.newidea.component.tools.StringUtils.compareVersion(popUpWindows.getParam().getCurVer(),
                                    versionExclusion.getSpecifiedVersion()) > 0;

                        case 2:
                            // 2 大于等于指定一版本的展示
                            if (StringUtils.isBlank(versionExclusion.getSpecifiedVersion())) {
                                // 未配置指定版本 则不过滤
                                return false;
                            }
                            // 如果当前版本小于配置版本则过滤
                            return com.bxm.newidea.component.tools.StringUtils.compareVersion(popUpWindows.getParam().getCurVer(),
                                    versionExclusion.getSpecifiedVersion()) < 0;
                        case 3:
                            // 3 等于指定的某些版本的展示
                            if (CollectionUtils.isEmpty(versionExclusion.getContainVersions())) {
                                // 未配置指定版本 则不过滤
                                return false;
                            }
                            // 不包含当前版本 则过滤
                            return !versionExclusion.getContainVersions().contains(popUpWindows.getParam().getCurVer());
                        case 4:
                            // 4 不等于指定的某些版本的展示
                            if (CollectionUtils.isEmpty(versionExclusion.getContainVersions())) {
                                // 未配置指定版本 则不过滤
                                return false;
                            }
                            // 包含当前版本 则过滤
                            return versionExclusion.getContainVersions().contains(popUpWindows.getParam().getCurVer());
                        default:
                    }

                    // 默认不过滤
                    return false;
                }).peek(p -> {
                    if (log.isDebugEnabled()) {
                        log.debug("版本过滤器, 过滤弹窗: {}, 当前版本: {}, 配置的版本信息: {}", p.getName(),
                                popUpWindows.getParam().getCurVer(), p.getVersionJson());
                    }
                }).collect(Collectors.toList());

        popUpWindows.getPopUpWindows().removeAll(removeList);
    }

}

/**
 * 版本过滤信息
 */
@Data
class VersionExclusion {

    /**
     * 过滤类型
     * 1 小于等于指定一版本展示
     * 2 大于等于指定一版本展示
     * 3 等于指定的某些版本展示
     * 4 不等于指定的某些版本的展示
     */
    private Byte type;

    /**
     * 指定的某一版本
     */
    private String specifiedVersion;

    /**
     * 包含的某些版本
     */
    private List<String> containVersions;
}
