package com.bxm.fossicker.base.service.impl.popup.interfacies;

import com.bxm.fossicker.vo.BasicParam;

/**
 * 定义弹窗处理类
 * 如：获取弹窗列表、弹窗次数记录、弹窗统计等
 * @author Gonzo
 * @date 2019-10-10 15:30
 */
public interface PopUpHandler<T extends BasicParam> {


    /**
     * 具体处理方法
     * @param t
     * @return 具体返回什么自己定义
     */
    <R> R handle(T t);

    /**
     * 支持的处理参数
     * @return
     */
    Class<? extends T> support();
}
