package com.bxm.fossicker.base.service.impl.popup.interfacies;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;

/**
 * 弹窗拦截器
 * 实现分为两类：
 *  一类是公共拦截器，专门针对通用的规则进行处理
 *  另外一类是针对某一个类型的弹窗所定义的处理器，这种处理器不单单做过滤的事情，也会集成其他功能如{@link ClosePopUp} 接口定义的弹窗关闭事件
 * @author Gonzo
 * @date 2019-10-10 14:07
 */
public interface PopUpWindowsInterceptor {

    /**
     * 过滤弹窗、记录弹窗弹出数据等
     * @param popUpWindows 要处理的弹窗以及请求数据
     */
    void invoke(FilterPopUpWindowsBO popUpWindows);
}
