package com.bxm.fossicker.base.service.impl.popup.process.homepage;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.config.PopUpProperties;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import com.google.common.collect.Maps;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import static com.bxm.fossicker.enums.UserJudgeMarkerEnum.SET_SPECIAL;

/**
 * 新版本上线前注册的用户，进入首页时弹出
 * 只弹一次
 *
 * @Author: Gonzo
 * @Date 2020-02-29 13:49
 * @since 1.6.0
 */
@PopUpProcess(special = PopUpEnum.GOLD_RATE_CHANGE, order = PopUpProcessOrderEn.CUSTOM)
public class GoldRateChangeWindowsProcess extends AbstractPopUpWindowsProcess {

    @Resource
    private PopUpProperties popUpProperties;

    @Resource
    private UserInfoFacadeService userInfoFacadeService;

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        // 判断用户是否1.6.0之前注册的
        UserInfoDto user = userInfoFacadeService.getUserById(popUpWindows.getParam().getUserId());

        if (Objects.isNull(user)
                || (Objects.nonNull(user.getJudgeMarker())
                    && BitOperatorUtil.getBitAsBoolean(user.getJudgeMarker(), SET_SPECIAL.getIndex()))) {

            // 1.6.0之后用户，直接永久关闭 添加弹出次数
            autoClose(popUpWindows, Boolean.TRUE, 1);
            // 移除金币兑换比例弹窗
            removeCurrent(popUpWindows);

            if (log.isDebugEnabled()) {
                log.debug("用户: {} 是新版本用户，不返回兑换比例弹窗", popUpWindows.getParam().getUserId());
            }
        }

        // SET_SPECIAL标识位 1.6.0之后增加，如果为空，则肯定是1.6.0之前用户的旧数据 则需要弹出金币调整弹窗
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        // 获取当前处理弹窗
        List<CommonPopUpWindowsEntry> commonPopUpWindowsEntryList = popUpWindows.getParam(CURRENT_PROCESS_SUPPORT_POP_UP_KEY);

        if (!CollectionUtils.isEmpty(commonPopUpWindowsEntryList)) {
            commonPopUpWindowsEntryList.forEach(p -> {
                Map<String, String> note = Maps.newHashMap();
                note.put("note", popUpProperties.getGoldChangeText());
                p.setExt(JSON.toJSONString(note));
            });
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = getPopId(param);

        if (Objects.isNull(popId)) {
            log.warn("未获取到弹窗id，无法记录首页《金币兑换比例调整弹窗》弹出, type: {}, popIp: {}",
                    param.getType(), param.getPopUpId());
            return;
        }

        closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }
}
