package com.bxm.fossicker.base.service.impl.popup.process.homepage;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.interceptor.ExclusionPopUpWindowsInterceptor;

import java.util.Objects;

/**
 * @authoer Gonzo
 * @date 2019-09-03 12:14
 *
 * 任务弹窗：用户每次启动app进入首页时弹出，一天只弹一次，与新人弹窗不同时触发
 *
 * 互斥的操作放在
 * @see ExclusionPopUpWindowsInterceptor
 *
 * 1.3.0已经去除
 * @deprecated
 */
@PopUpProcess(special = PopUpEnum.HOME_HOMEPAGE_TASK, order = PopUpProcessOrderEn.CUSTOM)
public class HomepageTaskPopUpWindowsProcess extends AbstractPopUpWindowsProcess {


    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {

        // 弹出次数与互斥的判断

        // 过滤已经在通用做了

    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {

        Long popId = getPopId(param);

        if (Objects.isNull(popId)) {
            log.warn("未获取到弹窗id，无法记录任务弹出, type: {}, popIp: {}", param.getType(), param.getPopUpId());
            return;
        }

        closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }

}
