package com.bxm.fossicker.base.service.impl.popup.process.homepage;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.activity.facade.ActivityFacadeService;
import com.bxm.fossicker.activity.facade.model.LoginRewardFacadeDTO;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

/**
 * 首页登录弹窗
 * 用户进入首页时弹出，用户需登录，一天弹一次
 * @Author: Gonzo
 * @Date 2020-02-11 18:16
 * @since 1.5.0
 */
@PopUpProcess(special = PopUpEnum.HOME_LOGIN_REWARD, order = PopUpProcessOrderEn.CUSTOM)
public class LoginRewardWindowsProcess extends AbstractPopUpWindowsProcess {

    @Autowired
    private ActivityFacadeService activityFacadeService;

    private static final String LOGIN_REWARD_FACADE_DTO = "LOGIN_REWARD_FACADE_DTO";

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        // 判断今日是否领取过
        LoginRewardFacadeDTO facadeDTO = activityFacadeService.loginRewardInfo(popUpWindows.getParam().getUserId());

        if (Objects.isNull(facadeDTO) || facadeDTO.getGot()) {
            // 移除
            remove(popUpWindows, PopUpEnum.HOME_LOGIN_REWARD);
        } else {
            // 为了添加弹窗数据
            popUpWindows.getParams().put(LOGIN_REWARD_FACADE_DTO, facadeDTO);
        }
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        // 获取当前处理弹窗
        List<CommonPopUpWindowsEntry> commonPopUpWindowsEntryList = popUpWindows.getParam(CURRENT_PROCESS_SUPPORT_POP_UP_KEY);

        if (!CollectionUtils.isEmpty(commonPopUpWindowsEntryList)) {
            commonPopUpWindowsEntryList.forEach(p -> {
                LoginRewardFacadeDTO facadeDTO = popUpWindows.getParam(LOGIN_REWARD_FACADE_DTO);

                // 添加可领取金额
                LoginRewardWindowsExt ext = new LoginRewardWindowsExt();
                ext.setReward(facadeDTO.getReward());

                p.setExt(JSON.toJSONString(ext));
            });
        }
    }


    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = getPopId(param);

        if (Objects.isNull(popId)) {
            log.warn("未获取到弹窗id，无法记录首页登录弹窗弹出, type: {}, popIp: {}", param.getType(), param.getPopUpId());
            return;
        }

        closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }

    @Data
    public class LoginRewardWindowsExt {
        /**
         * 登录奖励
         */
        private BigDecimal reward;
    }
}
