package com.bxm.fossicker.base.service.impl.popup.process.homepage;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;

import java.util.Objects;

/**
 * 新人引导弹窗
 * 进入首页时弹出，每个用户只弹一次
 * @authoer Gonzo
 * @date 2019-09-03 12:00
 */
@PopUpProcess(special = PopUpEnum.HOME_NOVICE_GUIDE, order = PopUpProcessOrderEn.CUSTOM)
public class NoviceGuideWindowsProcess extends AbstractPopUpWindowsProcess {

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {

    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {

    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {

        Long popId = getPopId(param);

        if (Objects.isNull(popId)) {
            log.warn("未获取到弹窗id，无法记录新人教程弹窗弹出, type: {}, popIp: {}", param.getType(), param.getPopUpId());
            return;
        }

        closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));

    }
}
