package com.bxm.fossicker.base.service.impl.popup.process.homepage;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.constant.UserRedisKeyConstant;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * @authoer Gonzo
 * @date 2019-09-03 12:00
 *
 * 新人弹窗：一个用户只弹一次
 * 未登录，新设备，首次进入首页时弹出
 * 已登录，进入首页，为新用户
 *
 */
@PopUpProcess(special = PopUpEnum.HOME_NOVICE, order = PopUpProcessOrderEn.CUSTOM)
public class NovicePopUpWindowsProcess extends AbstractPopUpWindowsProcess {


    @Autowired
    private UserInfoFacadeService userInfoFacadeService;

    @Override
    protected boolean preInvoke(FilterPopUpWindowsBO popUpWindows) {

        // 判断是否存在要处理的弹窗
        if (super.preInvoke(popUpWindows)) {
            //1.6.0版本去除新人礼包弹窗
            if (com.bxm.newidea.component.tools.StringUtils.compareVersion(popUpWindows.getParam().getCurVer(),
                    "1.6.0") >= 0) {
                remove(popUpWindows, PopUpEnum.HOME_NOVICE);
                return false;
            }
            return true;
        }

        return false;
    }

        @Override
        protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {

            // 查询用户信息
            UserInfoDto userInfoDto = userInfoFacadeService.getUserById(popUpWindows.getParam().getUserId());

            String token = redisHashMapAdapter.get(UserRedisKeyConstant.HASH_USER_TOKEN, Objects.toString(popUpWindows.getParam().getUserId()), String.class);

            // 如果未登录 则弹一次
            if (StringUtils.isBlank(token) || Objects.isNull(userInfoDto) || Objects.isNull(userInfoDto.getId())) {
                // 并自动记录设备的弹窗缓存，永久关闭 添加弹出次数
                autoClose(popUpWindows, Boolean.TRUE, 1);
                return;
            }

            // 已登录 未领取过新人礼包才弹出
            if (!Objects.isNull(userInfoDto.getCharacter()) && Objects.equals(userInfoDto.getClaimedPacket(), Boolean.FALSE)) {
                return;
            }

            // 已登录，且不是新人，则手动触发永久关闭弹窗 不添加弹出次数
            autoClose(popUpWindows, Boolean.TRUE, 0);
            // 移除弹窗
            remove(popUpWindows, PopUpEnum.HOME_NOVICE);
        }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        List<CommonPopUpWindowsEntry> commonPopUpWindowsEntryList = popUpWindows.getParam(CURRENT_PROCESS_SUPPORT_POP_UP_KEY);

        if (!CollectionUtils.isEmpty(commonPopUpWindowsEntryList)) {
            commonPopUpWindowsEntryList.forEach(p -> {
                // 添加弹窗信息 - 可领取金币
                p.setExt(p.getMaterialExt());
            });
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {

        /*Long popId = getPopId(param);

        if (Objects.isNull(popId)) {
            log.warn("未获取到弹窗id，无法记录新人弹窗弹出, type: {}, popIp: {}", param.getType(), param.getPopUpId());
            return;
        }

        closeAndIncrementTimes(popId,Objects.toString( param.getUserId()));*/
    }
}
