package com.bxm.fossicker.base.service.impl.popup.process.homepage;

import com.bxm.fossicker.activity.facade.SignFacadeService;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.Objects;

/**
 * 新人引导弹窗
 * 进入首页时弹出，每个设备只弹一次
 * @author Gonzo
 * @date 2019-10-15 14:13
 */
@PopUpProcess(special = PopUpEnum.HOME_SIGN_GUIDE, order = PopUpProcessOrderEn.CUSTOM)
public class SignGuidePopUpProcess extends AbstractPopUpWindowsProcess {

    @Autowired
    private SignFacadeService signFacadeService;

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {

        if (signFacadeService.didSign(popUpWindows.getParam().getUserId(), new Date())) {
            // 已签到，则自动关闭签到引导弹窗，并增加今日弹出次数
            autoClose(popUpWindows, Boolean.FALSE, 1);
            remove(popUpWindows, PopUpEnum.HOME_SIGN_GUIDE);
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = getPopId(param);

        if (Objects.isNull(popId)) {
            log.warn("未获取到弹窗id，无法记录新人引导弹窗弹出, type: {}, popIp: {}", param.getType(), param.getPopUpId());
            return;
        }

        closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }
}
