package com.bxm.fossicker.base.service.impl.popup.process.homepage;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.constant.PopWindowsRunParamKey;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;

import java.util.Objects;

/**
 * @authoer Gonzo
 * @date 2019-09-03 11:51
 *
 * 用户画像弹窗：一个用户只弹一次
 * 1.3.0移除
 * @deprecated
 */
@PopUpProcess(special = PopUpEnum.HOME_USER_PAINT, order = PopUpProcessOrderEn.CUSTOM)
public class UserPaintPopUpWindowsProcess extends AbstractPopUpWindowsProcess {

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {

        // 查询用户角色
        UserInfoDto userInfoDto = popUpWindows.getParam(PopWindowsRunParamKey.USER_INFO);

        if (!Objects.isNull(userInfoDto) && !Objects.isNull(userInfoDto.getCharacter())
                && userInfoDto.getCharacter().intValue() == 0) {
            return;
        }

        // 移除弹窗
        remove(popUpWindows, PopUpEnum.HOME_USER_PAINT);
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = getPopId(param);

        if (Objects.isNull(popId)) {
            log.warn("未获取到弹窗id，无法记录用户画像弹窗弹出, type: {}, popIp: {}", param.getType(), param.getPopUpId());
            return;
        }

        closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }
}
